/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoProduto;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.financeiro.enums.ModoCalculoCustoDRE;
import br.intelidata.commons.sped.fiscal.TipoCalculoCusto;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.report.Report;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.Dre;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class AbstractDreReportController
extends Report<Dre> {
    @DBAutoCommit
    public Dre get() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Dre dre = new Dre();
        dre.setConsideraInativo(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 807));
        dre.setTipoCalculoCusto((TipoCalculoCusto)EnumUtils.getPorId(TipoCalculoCusto.class, (Object)PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 805)));
        dre.setModoCalculoDre((ModoCalculoCustoDRE)EnumUtils.getPorId(ModoCalculoCustoDRE.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(sessao.getFilial(), 804)));
        dre.setConsideraNotasSaidaNaoVenda(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 874));
        dre.setProcessarImpostosPeloFinanceiro(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 875));
        dre.setComparativoMensal(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 983));
        return dre;
    }

    @RequestMapping(value={"/recuperadados"})
    @DBAutoCommit
    public Object getDreTree(@RequestBody Dre dre) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CustoMedioDiarioRN.getInstance().validarCustoMedio(dre.getTipoCalculoCusto(), dre.getPeriodoInicial(), dre.getPeriodoFinal(), dre.getFiliais());
        this.gravarParametros(sessao, dre);
        return this.getDre(sessao, dre);
    }

    protected abstract Object getDre(Sessao var1, Dre var2) throws UnicoMensagemUsuarioException;

    protected void gravarParametros(Sessao sessao, Dre dre) throws UnicoMensagemUsuarioException {
        PropriedadeRN.getInstance().setPropriedade(sessao, 807, Boolean.valueOf(dre.isConsideraInativo()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 805, dre.getTipoCalculoCusto() != null ? dre.getTipoCalculoCusto().getId() : null);
        PropriedadeRN.getInstance().setPropriedade(sessao, 804, dre.getModoCalculoDre() != null ? dre.getModoCalculoDre().getId() : null);
        PropriedadeRN.getInstance().setPropriedade(sessao, 874, Boolean.valueOf(dre.isConsideraNotasSaidaNaoVenda()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 875, Boolean.valueOf(dre.isProcessarImpostosPeloFinanceiro()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 983, Boolean.valueOf(dre.isComparativoMensal()));
        List tiposProduto = dre.getTiposProduto();
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 282, Boolean.valueOf(tiposProduto.contains(TipoProduto.MERCADORIA_PARA_REVENDA)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 283, Boolean.valueOf(tiposProduto.contains(TipoProduto.MATERIA_PRIMA)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 284, Boolean.valueOf(tiposProduto.contains(TipoProduto.EMBALAGEM)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 285, Boolean.valueOf(tiposProduto.contains(TipoProduto.PRODUTO_EM_PROCESSO)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 286, Boolean.valueOf(tiposProduto.contains(TipoProduto.PRODUTO_ACABADO)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 287, Boolean.valueOf(tiposProduto.contains(TipoProduto.SUBPRODUTOS)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 288, Boolean.valueOf(tiposProduto.contains(TipoProduto.PRODUTO_INTERMEDIARIO)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 289, Boolean.valueOf(tiposProduto.contains(TipoProduto.MATERIAL_USO_CONSUMO)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 290, Boolean.valueOf(tiposProduto.contains(TipoProduto.ATIVO_IMOBILIZADO)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 291, Boolean.valueOf(tiposProduto.contains(TipoProduto.SERVICOS)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 292, Boolean.valueOf(tiposProduto.contains(TipoProduto.OUTROS_INSUMOS)));
        PropriedadeRN.getInstance().setPropriedadeBoolean(sessao, 293, Boolean.valueOf(tiposProduto.contains(TipoProduto.OUTROS)));
    }
}

