/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasporpdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.vendas.relatorio.VendasPorECFRelatorio;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasporpdv.VendasPorPdv;

public class VendasPorPdvReportExecuter
extends AbstractReporteExecute<VendasPorPdv> {
    public VendasPorPdvReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        VendasPorPdv vendasPorPdv = (VendasPorPdv)this.fromJson(parametrosObj, VendasPorPdv.class);
        return this.executa(sessao, vendasPorPdv);
    }

    public Remessa executa(Sessao sessao, VendasPorPdv parametros) throws UnicoMensagemUsuarioException {
        String numeroNfce = parametros.getNumeroNFCe();
        if (!Util.stringNullOrEmpty((String)numeroNfce) && !Util.isApenasNumeros((String)numeroNfce)) {
            throw new UnicoMensagemUsuarioException("WPDV488", "N\u00famero NFCe/SAT inv\u00e1lido! Verifique.");
        }
        String horaInicio = "";
        if (parametros.getHoraInicio() != null) {
            horaInicio = parametros.getHoraInicio().toLocalTime().withSecond(0).withNano(0).toString();
        }
        String horaFim = "";
        if (parametros.getHoraFinal() != null) {
            horaFim = parametros.getHoraFinal().toLocalTime().withSecond(0).withNano(0).toString();
        }
        return new VendasPorECFRelatorio().getRelatorio(parametros.getSaida(), parametros.getFiliais(), parametros.getIdFinalizador(), parametros.getInicio(), parametros.getFim(), horaInicio, horaFim, parametros.isItens(), parametros.isCancelado(), parametros.getNumeroECFFiltro(), parametros.getNumeroCOO(), numeroNfce, parametros.getIdCliente(), parametros.isPorEcf(), parametros.isPorCliente(), parametros.isPorUsuario(), parametros.isImprimirNumeroDav(), parametros.getTurnoInicio(), parametros.getTurnoFim(), parametros.getTipoOperacao(), parametros.getIdUsuario());
    }
}

