/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.adm;

import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.LogSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.adm.SystemStatus;
import br.intelidata.uniplusweb.adm.job.DadosServicoDB;
import br.intelidata.uniplusweb.adm.job.Database;
import br.intelidata.uniplusweb.adm.job.TipoDBLog;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.SchedulersMap;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SystemStatusService {
    private final String SOVersion;
    private final LocalDateTime dataHoraStartUp;
    private final Double diskTotalSpace;
    private final Double memoryTotalSpace;
    private final int availableProcessors;
    private final String postgresVersion;
    private final String postgresMaxConnections;
    private final String postgresSharedBuffers;
    private final String postgresEffectiveCacheSize;
    private final String postgresMaintenanceWorkMem;
    private final String postgresCheckpointCompletionTarget;
    private final String postgresWalBuffers;
    private final String postgresDefaultStatisticsTarget;
    private final String postgresRandomPageCost;
    private final String postgresEffectiveIoConcurrency;
    private final String postgresWorkMem;
    private final String postgresMaxWorkerProcesses;
    private final Double javaHeapMax;
    private final DataSource dataSource;
    private final JobExecutorService jobExecutorService;
    private final TenantService tenantService;
    private final IConnectionHandler connectionHandler;
    private final MDCConfigService mdcConfigService;

    public SystemStatusService(DataSource dataSource, JobExecutorService jobExecutorService, TenantService tenantService, IConnectionHandler connectionHandler, MDCConfigService mdcConfigService) {
        this.dataSource = dataSource;
        this.jobExecutorService = jobExecutorService;
        this.tenantService = tenantService;
        this.connectionHandler = connectionHandler;
        this.mdcConfigService = mdcConfigService;
        this.SOVersion = ManagementFactory.getOperatingSystemMXBean().getName() + " " + ManagementFactory.getOperatingSystemMXBean().getVersion() + " (" + ManagementFactory.getOperatingSystemMXBean().getArch() + ")";
        File file = new File(".");
        this.dataHoraStartUp = LocalDateTime.now();
        this.diskTotalSpace = this.toGB(Long.valueOf(file.getTotalSpace()));
        this.memoryTotalSpace = this.toMB(Long.valueOf(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize()));
        this.availableProcessors = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        this.postgresVersion = this.pgVersion();
        this.postgresMaxConnections = this.pgShow("max_connections");
        this.postgresSharedBuffers = this.pgShow("shared_buffers");
        this.postgresEffectiveCacheSize = this.pgShow("effective_cache_size");
        this.postgresMaintenanceWorkMem = this.pgShow("maintenance_work_mem");
        this.postgresCheckpointCompletionTarget = this.pgShow("checkpoint_completion_target");
        this.postgresWalBuffers = this.pgShow("wal_buffers");
        this.postgresDefaultStatisticsTarget = this.pgShow("default_statistics_target");
        this.postgresRandomPageCost = this.pgShow("random_page_cost");
        this.postgresEffectiveIoConcurrency = this.pgShow("effective_io_concurrency");
        this.postgresWorkMem = this.pgShow("work_mem");
        this.postgresMaxWorkerProcesses = this.pgShow("max_worker_processes");
        this.javaHeapMax = this.toMB(Long.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax()));
    }

    public SystemStatus getSystemStatus() {
        SystemStatus status = new SystemStatus();
        status.setSoVersion(this.SOVersion);
        status.setDataInicio(this.dataHoraStartUp);
        status.setDataRegistro(LocalDateTime.now());
        status.setAvailableProcessors(this.availableProcessors);
        double cpu = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
        status.setSystemCpuLoad(Double.valueOf(Math.floor(cpu * 10000.0) / 100.0));
        status.setMemoryTotalSpace(this.memoryTotalSpace);
        status.setMemoryFreeSpace(this.toMB(Long.valueOf(Runtime.getRuntime().freeMemory())));
        File file = new File(".");
        status.setDiskFreeSpace(this.toGB(Long.valueOf(file.getFreeSpace())));
        status.setDiskTotalSpace(this.diskTotalSpace);
        status.setJavaHeapMax(this.javaHeapMax);
        status.setJavaHeapUsed(this.toMB(Long.valueOf(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())));
        status.setJavaNonHeapUsed(this.toMB(Long.valueOf(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed())));
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Long databaseConnections = (Long)jt.queryForObject("select count(*) from pg_stat_activity", Long.class);
        status.setDatabaseConnections(databaseConnections);
        status.setPostgresVersion(this.postgresVersion);
        status.setPostgresMaxConnections(this.postgresMaxConnections);
        status.setPostgresSharedBuffers(this.postgresSharedBuffers);
        status.setPostgresEffectiveCacheSize(this.postgresEffectiveCacheSize);
        status.setPostgresMaintenanceWorkMem(this.postgresMaintenanceWorkMem);
        status.setPostgresCheckpointCompletionTarget(this.postgresCheckpointCompletionTarget);
        status.setPostgresWalBuffers(this.postgresWalBuffers);
        status.setPostgresDefaultStatisticsTarget(this.postgresDefaultStatisticsTarget);
        status.setPostgresRandomPageCost(this.postgresRandomPageCost);
        status.setPostgresEffectiveIoConcurrency(this.postgresEffectiveIoConcurrency);
        status.setPostgresWorkMem(this.postgresWorkMem);
        status.setPostgresMaxWorkerProcesses(this.postgresMaxWorkerProcesses);
        status.setUniplusBuild(UnicoSistema.getVersao());
        status.setUniplusJobPoolSize(this.jobExecutorService.getPoolSize());
        status.setUniplusSchedulers(SchedulersMap.getExecucoes());
        status.setDatabaseList(this.getDatabases());
        return status;
    }

    private Double toGB(Long number) {
        return Math.floor((double)number.longValue() / 1.073741824E9 * 100.0) / 100.0;
    }

    private Double toMB(Long number) {
        return Math.floor((double)number.longValue() / 1048576.0 * 100.0) / 100.0;
    }

    private String pgShow(String config) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        return (String)jt.queryForObject("show " + config, String.class);
    }

    private String pgVersion() {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        return (String)jt.queryForObject("select version()", String.class);
    }

    private List<Database> getDatabases() {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        List lista = jt.query("SELECT pg_database.datname as name, pg_database_size(pg_database.datname)/1024/1024 AS size FROM pg_database ORDER by size DESC", (rs, rowNum) -> new Database(rs.getString("name"), rs.getInt("size")));
        jt.query("SELECT codigo, urldatabase FROM tenant ORDER by id", rs -> {
            String codigo = rs.getString(1);
            String url = rs.getString(2);
            for (Database db : lista) {
                if (!url.endsWith(db.getName())) continue;
                db.setTenant(codigo);
                break;
            }
        });
        lista.removeIf(db -> Util.stringNullOrEmpty((String)db.getTenant()));
        return lista;
    }

    private void buscarDadosManutencaaoDB(TipoDBLog tipoDBLog, List<Database> listaDB) {
        try {
            File arquivo = this.getArquivoMaisNovoPorPrefixo(tipoDBLog.getId());
            if (arquivo != null) {
                block2: for (String linha : Files.readAllLines(arquivo.toPath())) {
                    if (linha.trim().isEmpty()) continue;
                    String[] partesLinha = linha.split(";");
                    String tenant = partesLinha[0];
                    for (Database database : listaDB) {
                        if (!database.getTenant().equalsIgnoreCase(tenant)) continue;
                        LocalDateTime inicio = DataHoraFactory.string2LocalDateTime((String)partesLinha[1], (String)"yyyy-MM-dd_HH:mm:ss");
                        LocalDateTime fim = DataHoraFactory.string2LocalDateTime((String)partesLinha[2], (String)"yyyy-MM-dd_HH:mm:ss");
                        Integer resultado = Integer.valueOf(partesLinha[3]);
                        database.getDadosManutencaoDB().put(tipoDBLog, new DadosServicoDB(inicio, Long.valueOf(ChronoUnit.MILLIS.between(inicio, fim)), resultado, ""));
                        continue block2;
                    }
                }
            }
        }
        catch (Throwable ex) {
            LogSistema.escreveErroFatal((Throwable)ex);
        }
    }

    private File getArquivoMaisNovoPorPrefixo(String prefixo) {
        File dir = new File("/var/app/stats");
        if (dir.exists()) {
            Object[] files = dir.listFiles();
            if (ListMapUtil.arrayNullOrEmpty((Object[])files)) {
                return null;
            }
            Object arquivoMaisNovo = null;
            ArrayList<Object> arquivosParaExcluir = new ArrayList<Object>();
            for (Object file : files) {
                if (((File)file).isDirectory() || !((File)file).getName().startsWith(prefixo)) continue;
                if (arquivoMaisNovo == null || ((File)arquivoMaisNovo).lastModified() < ((File)file).lastModified()) {
                    arquivoMaisNovo = file;
                    continue;
                }
                arquivosParaExcluir.add(file);
            }
            for (File file : arquivosParaExcluir) {
                try {
                    FileUtil.excluirArquivo((File)file);
                }
                catch (Throwable ex) {
                    LogSistema.escreveErroFatal((Throwable)ex);
                }
            }
            return arquivoMaisNovo;
        }
        return null;
    }
}

