/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.config;

import br.intelidata.uniplusweb.config.UnipluswebProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

public class SwaggerConfiguration {
    private final Logger log = LoggerFactory.getLogger(SwaggerConfiguration.class);
    public static final String DEFAULT_INCLUDE_PATTERN = "/api/.*";

    @Bean
    public Docket swaggerSpringfoxDocket(UnipluswebProperties unipluswebProperties) {
        this.log.debug("Iniciando Swagger...");
        StopWatch watch = new StopWatch();
        watch.start();
        ApiInfo apiInfo = new ApiInfo(unipluswebProperties.getSwagger().getTitle(), unipluswebProperties.getSwagger().getDescription(), unipluswebProperties.getSwagger().getVersion(), unipluswebProperties.getSwagger().getTermsOfServiceUrl(), unipluswebProperties.getSwagger().getContact(), unipluswebProperties.getSwagger().getLicense(), unipluswebProperties.getSwagger().getLicenseUrl());
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).genericModelSubstitutes(new Class[]{ResponseEntity.class}).forCodeGeneration(true).genericModelSubstitutes(new Class[]{ResponseEntity.class}).directModelSubstitute(LocalDate.class, String.class).directModelSubstitute(ZonedDateTime.class, Date.class).directModelSubstitute(LocalDateTime.class, Date.class).select().paths(PathSelectors.regex((String)DEFAULT_INCLUDE_PATTERN)).build();
        watch.stop();
        this.log.debug("Swagger iniciado em {} ms", (Object)watch.getTotalTimeMillis());
        return docket;
    }
}

