/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.domain.pojo.enuns.TipoExtensaoPlanilha;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ResponseEntityService {
    public ResponseEntity<byte[]> createHtmlResponse(byte[] html, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + ".html");
        return new ResponseEntity((Object)html, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<String> createJSONResponse(String json) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return new ResponseEntity((Object)json, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createPDFResponse(byte[] pdf) {
        return this.createPDFResponse(pdf, "documento");
    }

    public ResponseEntity<byte[]> createPDFResponse(byte[] pdf, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_PDF);
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + ".pdf");
        return new ResponseEntity((Object)pdf, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createXLSResponse(byte[] xls, TipoExtensaoPlanilha extensao) {
        return this.createXLSResponse(xls, "documento", extensao);
    }

    public ResponseEntity<byte[]> createXMLResponse(byte[] xml, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/xml"));
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + ".xml");
        return new ResponseEntity((Object)xml, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createFileResponse(byte[] bytes, MediaType type, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(type);
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createXLSResponse(byte[] xls, String name, TipoExtensaoPlanilha extensao) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)extensao.getContentType()));
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + extensao.getExtensao());
        return new ResponseEntity((Object)xls, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createZIPResponse(byte[] file, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/zip"));
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + ".zip");
        return new ResponseEntity((Object)file, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<Resource> createSourceResponse(Resource resource, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name);
        return new ResponseEntity((Object)resource, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public ResponseEntity<byte[]> createTXTResponse(byte[] txt) {
        return this.createTXTResponse(txt, "documento");
    }

    public ResponseEntity<byte[]> createTXTResponse(byte[] txt, String name) {
        HttpHeaders responseHeaders = this.getDefaultHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        responseHeaders.add("Content-Disposition", "attachment;filename=" + name + ".txt");
        responseHeaders.add("Content-Type", "text/plain; charset=utf-8");
        return new ResponseEntity((Object)txt, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders getDefaultHeaders() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("access-control-expose-headers", "content-disposition");
        return responseHeaders;
    }
}

