/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.multitenant;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.security.AutenticacaoException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TenantService {
    @Autowired
    private DataSource dataSource;

    public List<Tenant> getTenants() {
        return this.getTenants(false);
    }

    public List<Tenant> getTenants(boolean somenteAtivos) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = "select id,codigo,descricao,inativo,inicializado,urldatabase,usuarios,ultimoacesso,validoate,secret from tenant";
        if (somenteAtivos) {
            sql = sql + " where inativo = 0 AND inicializado = 1";
        }
        sql = sql + " order by id";
        return jdbcTemplate.query(sql, new Object[0], (rs, rowNum) -> new Tenant(Long.valueOf(rs.getLong("id")), rs.getString("codigo"), rs.getString("descricao"), rs.getString("urldatabase"), rs.getInt("inativo"), rs.getInt("inicializado"), rs.getInt("usuarios"), DataHoraFactory.date2LocalDateTime((Date)rs.getTimestamp("ultimoacesso")), DataHoraFactory.date2LocalDate((Date)rs.getDate("validoate")), rs.getString("secret")));
    }

    public Tenant getTenant(String idTenant) {
        return this.getTenant(idTenant, true);
    }

    public Tenant getTenant(String idTenant, boolean validar) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        List tenants = jdbcTemplate.query("select id,codigo,descricao,inativo,inicializado,urldatabase,usuarios,ultimoacesso,validoate,secret from tenant where codigo = ?", new Object[]{idTenant}, (rs, rowNum) -> new Tenant(Long.valueOf(rs.getLong("id")), rs.getString("codigo"), rs.getString("descricao"), rs.getString("urldatabase"), rs.getInt("inativo"), rs.getInt("inicializado"), rs.getInt("usuarios"), DataHoraFactory.date2LocalDateTime((Date)rs.getTimestamp("ultimoacesso")), DataHoraFactory.date2LocalDate((Date)rs.getDate("validoate")), rs.getString("secret")));
        if (tenants.isEmpty()) {
            if (validar) {
                throw new AutenticacaoException("Conta n\u00e3o definida.");
            }
            return null;
        }
        return (Tenant)tenants.get(0);
    }

    public void atualizaUltimoAcesso(String idTenant) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update tenant set ultimoacesso=now() where codigo = ?", new Object[]{idTenant});
    }

    public void inicializaTenant(String idTenant) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update tenant set inicializado=1 where codigo = ?", new Object[]{idTenant});
    }

    public void validaTenant(String idTenant) {
        Tenant tenant = this.getTenant(idTenant);
        if (tenant.getInativo() == 1) {
            throw new AutenticacaoException("Conta inativa. Verifique!");
        }
        if (tenant.getInicializado() == 0) {
            throw new AutenticacaoException("Conta n\u00e3o inicializada. Verifique!");
        }
    }

    public String getDatabase(String idTenant) {
        if (!StringUtil.stringNullOrEmpty((String)idTenant)) {
            return this.getDatabase(this.getTenant(idTenant, false));
        }
        return null;
    }

    public String getDatabase(Tenant tenant) {
        if (tenant != null) {
            return tenant.getUrlDatabase().split("/")[3];
        }
        return null;
    }
}

