/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Email;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ParametrosEmail;
import br.intelidata.commons.domain.pojo.enuns.TipoServicoCaixaEmail;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);

    public static ParametrosEmailWeb getParametros(Sessao sessao, String emailDestino, String emailCC, String assunto, String mensagem) throws UnicoMensagemUsuarioException {
        return EmailUtil.getParametros((Sessao)sessao, (ParametrosEmail)Email.getParametrosEmail((Sessao)sessao), (String)emailDestino, (String)emailCC, (String)assunto, (String)mensagem);
    }

    public static ParametrosEmailWeb getParametros(Sessao sessao, ParametrosEmail parametrosEmail, String emailDestino, String emailCC, String assunto, String mensagem) throws UnicoMensagemUsuarioException {
        ParametrosEmailWeb parametros = new ParametrosEmailWeb(parametrosEmail);
        String assinatura = "";
        String arquivoImagemEmail = "";
        if (sessao.getUsuario() != null) {
            assinatura = sessao.getUsuario().getAssinatura();
            arquivoImagemEmail = sessao.getUsuario().getArquivoImagemEmail();
        }
        parametros.setAssinatura(assinatura);
        parametros.setArquivoImagemEmail(arquivoImagemEmail);
        if (StringUtil.stringNullOrEmpty((String)emailDestino)) {
            throw new UnicoMensagemUsuarioException("COM236484", "Por favor informe o e-mail de destinat\u00e1rio.");
        }
        parametros.setEmailDestino(emailDestino);
        if (!StringUtil.stringNullOrEmpty((String)emailCC)) {
            parametros.setEmailCC(emailCC);
        }
        parametros.setAssunto(assunto);
        parametros.setMensagem(mensagem);
        return parametros;
    }

    public static String enviarEmail(Sessao sessao, ParametrosEmailWeb parametros, List<DataSource> anexosAdicionais) throws UnicoMensagemUsuarioException {
        Session mailSession;
        String emailDestino = parametros.getEmailDestino();
        if (parametros.getEmailDestino().split("@").length == 2 && parametros.getEmailDestino().endsWith(";")) {
            emailDestino = emailDestino.substring(0, emailDestino.length() - 1);
        }
        log.info("Preparando envio de e-mail para " + emailDestino);
        String emailDestinoRetorno = emailDestino;
        if (parametros.getTipoServicoCaixaEmail().equals((Object)TipoServicoCaixaEmail.GOOGLE)) {
            mailSession = Session.getInstance((Properties)new Properties());
        } else {
            Properties mailProps = Email.getProperties((ParametrosEmail)parametros, (String)emailDestino);
            mailSession = Session.getInstance((Properties)mailProps, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
            mailSession.setDebug(true);
        }
        log.info("Montando o e-mail");
        MimeMessage message = EmailUtil.getMensagem((Session)mailSession, (ParametrosEmailWeb)parametros, (String)emailDestinoRetorno, (String)parametros.getEmailDestino(), anexosAdicionais);
        log.info("Enviando...");
        Email.sendMail((Sessao)sessao, (Session)mailSession, (ParametrosEmail)parametros, (MimeMessage)message);
        log.info("E-mail enviado com sucesso");
        return emailDestinoRetorno;
    }

    private static MimeMessage getMensagem(Session mailSession, ParametrosEmailWeb parametros, String emailDestinoRetorno, String emailDestino, List<DataSource> anexosAdicionais) throws UnicoMensagemUsuarioException {
        try {
            File fileImgEmail;
            int i;
            Object[] emailsCC;
            MimeMessage email = new MimeMessage(mailSession);
            email.setSentDate(new Date());
            String[] emails = emailDestino.split(";");
            if (emails.length > 1) {
                InternetAddress[] listaDestinatarios = new InternetAddress[emails.length];
                for (int i2 = 0; i2 < emails.length; ++i2) {
                    listaDestinatarios[i2] = new InternetAddress(emails[i2]);
                }
                email.setRecipients(Message.RecipientType.TO, (Address[])listaDestinatarios);
            } else {
                email.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailDestino));
            }
            if (!Util.stringNullOrEmpty((String)parametros.getEmailCC())) {
                emailsCC = parametros.getEmailCC().split(";");
                if (!Util.arrayNullOrEmpty((Object[])emailsCC)) {
                    InternetAddress[] listaEmails = new InternetAddress[emailsCC.length];
                    for (i = 0; i < emailsCC.length; ++i) {
                        emailDestinoRetorno = emailDestinoRetorno.concat(", ").concat((String)emailsCC[i]);
                        listaEmails[i] = new InternetAddress((String)emailsCC[i]);
                    }
                    email.addRecipients(Message.RecipientType.CC, (Address[])listaEmails);
                } else {
                    emailDestinoRetorno = emailDestinoRetorno + ", ".concat(parametros.getEmailCC());
                    email.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)parametros.getEmailCC()));
                }
            }
            if (!Util.stringNullOrEmpty((String)parametros.getEmailCCPreferencias())) {
                emailsCC = parametros.getEmailCCPreferencias().split(";");
                if (!Util.arrayNullOrEmpty((Object[])emailsCC)) {
                    InternetAddress[] listaEmails = new InternetAddress[emailsCC.length];
                    for (i = 0; i < emailsCC.length; ++i) {
                        listaEmails[i] = new InternetAddress((String)emailsCC[i]);
                        emailDestinoRetorno = emailDestinoRetorno.concat(", ").concat((String)emailsCC[i]);
                    }
                    email.addRecipients(Message.RecipientType.BCC, (Address[])listaEmails);
                } else {
                    emailDestinoRetorno = emailDestinoRetorno + ", ".concat(parametros.getEmailCC());
                    email.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)parametros.getEmailCCPreferencias()));
                }
            }
            String mensagem = parametros.getMensagem();
            if (!Util.stringNullOrEmpty((String)parametros.getAssinatura())) {
                mensagem = mensagem + Util.newLine() + Util.newLine() + Util.newLine() + Util.newLine() + parametros.getAssinatura();
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (!Util.stringNullOrEmpty((String)parametros.getArquivoImagemEmail()) && (fileImgEmail = new File(parametros.getArquivoImagemEmail())).exists()) {
                mensagem = mensagem + Util.newLine() + "<img src=\"cid:image\">";
                FileDataSource fds = new FileDataSource(parametros.getArquivoImagemEmail());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                messageBodyPart.setHeader("Content-ID", "<image>");
            }
            mensagem = Email.colocaNegritoTexto((String)mensagem);
            MimeBodyPart mbp1 = new MimeBodyPart();
            if (parametros.isMsgHtml()) {
                mbp1.setContent((Object)mensagem, "text/html; charset=UTF-8");
            } else {
                mbp1.setContent((Object)mensagem.replaceAll("(\r\n|\n)", "<br />"), "text/html; charset=UTF-8");
            }
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            if (!Util.stringNullOrEmpty((String)parametros.getArquivoImagemEmail())) {
                mp.addBodyPart((BodyPart)messageBodyPart);
            }
            if (!ListMapUtil.arrayNullOrEmpty((Object[])parametros.getAnexosEmArquivo())) {
                log.info("Anexando os arquivos em disco.");
                for (String arquivo : parametros.getAnexosEmArquivo()) {
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(arquivo);
                    mbp2.setDataHandler(new DataHandler((DataSource)fds));
                    mbp2.setFileName(fds.getName());
                    mp.addBodyPart((BodyPart)mbp2);
                }
            }
            if (!ListMapUtil.listNullOrEmpty(anexosAdicionais)) {
                log.info("Anexando os arquivos gravados em banco ou bucket.");
                for (DataSource dataSource : anexosAdicionais) {
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    mbp2.setDataHandler(new DataHandler(dataSource));
                    mbp2.setFileName(dataSource.getName());
                    mp.addBodyPart((BodyPart)mbp2);
                }
            }
            long tamanho = 0L;
            for (int i3 = 0; i3 < mp.getCount(); ++i3) {
                DataHandler dataHandler = mp.getBodyPart(i3).getDataHandler();
                if (dataHandler == null) continue;
                tamanho += (long)dataHandler.getDataSource().getInputStream().available();
            }
            Email.validarTamanhoArquivo((long)tamanho, (String)parametros.getServidorSmtp());
            if (Util.stringNullOrEmpty((String)parametros.getEmailEnvio())) {
                throw new UnicoMensagemUsuarioException("WWW266", "O destinat\u00e1rio do email \u00e9 obrigat\u00f3rio");
            }
            email.setFrom((Address)new InternetAddress(parametros.getEmailEnvio()));
            if (Util.stringNullOrEmpty((String)parametros.getAssunto())) {
                throw new UnicoMensagemUsuarioException("WWW267", "O assunto do email \u00e9 obrigat\u00f3rio");
            }
            email.setSubject(parametros.getAssunto(), "UTF-8");
            email.setContent((Multipart)mp);
            return email;
        }
        catch (MessagingException e) {
            throw new UnicoMensagemUsuarioException("WWW268", "N\u00e3o foi poss\u00edvel montar o email", (Throwable)e);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW269", "N\u00e3o foi poss\u00edvel montar o email", (Throwable)e);
        }
    }
}

