/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.uniplusweb.core.coreinterfaces.Profile;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.ResponseErrorOAuth2;
import java.util.Collections;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service
public class ConnectionOAuth2Service {
    private static final String CONTROLLER = "/uniplus/";
    private final Profile profile;

    public ConnectionOAuth2Service(Profile profile) {
        this.profile = profile;
    }

    private OAuth2RestTemplate getRestTemplate() {
        ClientCredentialsResourceDetails resource = new ClientCredentialsResourceDetails();
        resource.setAccessTokenUri(this.getEnderecoWS() + "/oauth/token");
        resource.setClientId("uniplus");
        resource.setClientSecret("l4gtr1ck2rspr3ngcl3ent");
        return new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource);
    }

    public <T> ResponseEntity<T> post(String endpoint, JSONObject jsonObject, Class<T> objectReturn) throws UnicoMensagemUsuarioException {
        return this.execute(CONTROLLER, endpoint, jsonObject, objectReturn, HttpMethod.POST, new Object[0]);
    }

    public <T> ResponseEntity<T> put(String endpoint, JSONObject jsonObject, Class<T> objectReturn) throws UnicoMensagemUsuarioException {
        return this.execute(CONTROLLER, endpoint, jsonObject, objectReturn, HttpMethod.PUT, new Object[0]);
    }

    public <T> ResponseEntity<T> get(String endpoint, Class<T> objectReturn, Object ... uriVariables) throws UnicoMensagemUsuarioException {
        return this.execute(CONTROLLER, endpoint, new JSONObject(), objectReturn, HttpMethod.GET, uriVariables);
    }

    public <T> ResponseEntity<T> execute(String controller, String endpoint, JSONObject jsonObject, Class<T> ObjectReturn, HttpMethod method, Object ... uriVariables) throws UnicoMensagemUsuarioException {
        ResponseEntity response;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        HttpEntity entityCredentials = jsonObject != null ? new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)httpHeaders) : new HttpEntity((MultiValueMap)httpHeaders);
        try {
            response = restTemplate.exchange(this.getEnderecoWS() + controller + endpoint, method, entityCredentials, ObjectReturn, uriVariables);
        }
        catch (Exception e) {
            byte[] data;
            ResponseErrorOAuth2 error;
            if ((e instanceof HttpClientErrorException || e instanceof HttpServerErrorException) && (error = (ResponseErrorOAuth2)JsonUtil.fromJson((String)Util.byteArrayToString((byte[])(data = e instanceof HttpClientErrorException ? ((HttpClientErrorException)e).getResponseBodyAsByteArray() : ((HttpServerErrorException)e).getResponseBodyAsByteArray())), ResponseErrorOAuth2.class)) != null) {
                throw new UnicoMensagemUsuarioException("WWW312", error.getStatus() + " - " + error.getMessage());
            }
            throw new UnicoMensagemUsuarioException("WWW313", "Ocorreu um erro ao consultar o webservice", (Throwable)e);
        }
        return response;
    }

    private String getEnderecoWS() {
        if (this.profile.isDev()) {
            return "http://localhost:8081";
        }
        return "https://canal.intelidata.inf.br";
    }
}

