/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.api.b2c.service.placeholder.ParametrosPlaceHolder;
import br.intelidata.api.b2c.service.placeholder.PlaceHolder;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ProdutoImagem;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoImagem;
import br.intelidata.commons.domain.regranegocio.b2c.PlaceHolderRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoImagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.wrapper.ProdutoDadoWrapper;
import com.amazonaws.services.s3.AmazonS3;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="ImportacaoProdutoImagemService")
public class ImportacaoProdutoImagemService
implements PlaceHolder {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String diretorio;
    private final StorageService storageService;

    public ImportacaoProdutoImagemService(@Value(value="${placeholder.produtos:''}") String diretorio, StorageService storageService) {
        this.storageService = storageService;
        if (Util.stringNullOrEmpty((String)diretorio)) {
            diretorio = Util.getDiretorioAplicacao() + File.separator + "IMAGENS_PRODUTO";
        }
        Util.criarDiretorio((File)new File(diretorio));
        this.diretorio = diretorio;
    }

    public StringBuilder processarDiretorio(String diretorioTemporario, ParametrosPlaceHolder parametros) {
        Path diretorio = Paths.get(diretorioTemporario, new String[0]);
        if (Files.exists(diretorio, new LinkOption[0])) {
            StringBuilder erros = this.verificarArquivos(parametros, diretorioTemporario, false, false);
            try {
                FileUtils.deleteDirectory((File)diretorio.toFile());
            }
            catch (IOException e) {
                this.getLogger().error("N\u00e3o foi poss\u00edvel excluir o diret\u00f3rio tempor\u00e1rio.", (Throwable)e);
            }
            return erros;
        }
        throw new UnicoException("WWW620", "O diret\u00f3rio tempor\u00e1rio de arquivos n\u00e3o existe mais.");
    }

    public StringBuilder verificarArquivos(ParametrosPlaceHolder parametrosPlaceHolder, String diretorio, boolean gravarArquivoLog, boolean moverArquivosInvalidos) {
        StringBuilder sbErrosImportacao = new StringBuilder();
        File dir = new File(diretorio);
        String[] paths = dir.list();
        if (paths != null) {
            HashMap mapPath = new HashMap();
            Arrays.stream(paths).sorted(Comparator.comparing(String::toString)).forEach(path -> {
                Object[] splitNome = path.split("-");
                if (!Util.arrayNullOrEmpty((Object[])splitNome) && splitNome.length > 1) {
                    Object eanCodigo = splitNome[0];
                    mapPath.computeIfAbsent(eanCodigo, k -> new ArrayList()).add(path);
                } else {
                    sbErrosImportacao.append("Imagem: ").append((String)path).append(" - Ean/C\u00f3digo inv\u00e1lido. (Esperado na primeira posi\u00e7\u00e3o separado por h\u00edfen. Ex: 3014260274917-Carga_para_Aparelho_de_Barbear_01.jpg)").append(Util.newLine());
                }
            });
            HashMap arquivosValidos = new HashMap();
            for (Map.Entry entry : mapPath.entrySet()) {
                String eanCodigo = (String)entry.getKey();
                Long idProduto = ProdutoRN.getInstance().buscarIdPorEanCodigo(eanCodigo);
                if (!Util.longNullOuZero((Long)idProduto)) {
                    ArrayList arquivos = new ArrayList(((List)entry.getValue()).size());
                    ((List)entry.getValue()).forEach(arquivo -> {
                        Path path = Paths.get(diretorio + File.separator + arquivo, new String[0]);
                        if (!Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0])) {
                            try {
                                new PlaceHolderRN().validarImagem(path);
                                arquivos.add(path);
                            }
                            catch (UnicoMensagemUsuarioException ex) {
                                sbErrosImportacao.append("Imagem: ").append((String)arquivo).append(" - ").append(ex.getMensagemSemCodigo()).append(Util.newLine());
                            }
                        } else {
                            sbErrosImportacao.append("Imagem: ").append(path.getFileName()).append(" - Arquivo n\u00e3o encontrado.").append(Util.newLine());
                        }
                    });
                    if (arquivos.size() <= 0) continue;
                    arquivosValidos.put(new ProdutoDadoWrapper(eanCodigo, idProduto), arquivos);
                    continue;
                }
                sbErrosImportacao.append("Imagem: ").append((String)((List)entry.getValue()).get(0)).append(" - Produto n\u00e3o encontrado.").append(Util.newLine());
            }
            this.uploadArquivos(arquivosValidos, sbErrosImportacao);
        }
        return sbErrosImportacao;
    }

    private void uploadArquivos(Map<ProdutoDadoWrapper, List<Path>> arquivosValidos, StringBuilder sbErrosImportacao) {
        Sessao sessao = SessaoUtil.getSessao();
        for (Map.Entry<ProdutoDadoWrapper, List<Path>> entry : arquivosValidos.entrySet()) {
            ProdutoDadoWrapper produto = entry.getKey();
            for (Path path : entry.getValue()) {
                try {
                    Path fileName = path.getFileName();
                    if (fileName == null) continue;
                    String nomeArquivo = fileName.toString();
                    String[] split = nomeArquivo.replace(FilenameUtils.getExtension((String)nomeArquivo), "").split("-");
                    int tipo = split[1] != null ? Integer.parseInt(split[1].substring(0, 1)) : -1;
                    TipoProdutoImagem tipoImagem = (TipoProdutoImagem)EnumUtils.getPorId(TipoProdutoImagem.class, (Object)tipo);
                    if (tipoImagem == null) {
                        sbErrosImportacao.append("Imagem: ").append(path.getFileName()).append(" - N\u00e3o foi poss\u00edvel determinar o tipo da imagem.").append(Util.newLine());
                        continue;
                    }
                    MockMultipartFile multipartFile = new MockMultipartFile(nomeArquivo, nomeArquivo, new MimetypesFileTypeMap().getContentType(nomeArquivo), IOUtils.toByteArray((URI)path.toUri()));
                    String url = this.storageService.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, (MultipartFile)multipartFile);
                    if (TipoProdutoImagem.PADRAO.equals((Object)tipoImagem) || TipoProdutoImagem.ICONE.equals((Object)tipoImagem)) {
                        Sql sqlProduto = new Sql(new UUpdate("produto", produto.getIdProduto(), new ColunaUPD[]{new ColunaUPD(TipoProdutoImagem.PADRAO.equals((Object)tipoImagem) ? "caminhoimagem" : "caminhoicone", url)}));
                        sqlProduto.executaUpdate();
                        sqlProduto.close();
                        continue;
                    }
                    ProdutoImagem produtoImagem = ProdutoImagemRN.getInstance().buscar(produto.getIdProduto(), tipoImagem);
                    if (produtoImagem != null) {
                        produtoImagem.setCaminhoImagem(url);
                        ProdutoImagemRN.getInstance().alterar((AbstractPojo)produtoImagem, sessao);
                        continue;
                    }
                    produtoImagem = new ProdutoImagem();
                    produtoImagem.setIdProduto(produto.getIdProduto());
                    produtoImagem.setCaminhoImagem(url);
                    produtoImagem.setTipoImagem(tipoImagem);
                    ProdutoImagemRN.getInstance().incluir((AbstractPojo)produtoImagem, sessao);
                }
                catch (UnicoMensagemUsuarioException | IOException ex) {
                    String message = ex instanceof UnicoMensagemUsuarioException ? ((UnicoMensagemUsuarioException)ex).getMensagemSemCodigo() : ex.getMessage();
                    sbErrosImportacao.append("Imagem: ").append(path.getFileName()).append(" - N\u00e3o foi poss\u00edvel salvar o arquivo.").append(message).append(Util.newLine());
                }
            }
        }
    }

    public String getDiretorioBase() {
        return this.diretorio;
    }

    public Logger getLogger() {
        return this.log;
    }

    public AmazonS3 getAmazonS3() {
        return null;
    }

    public String getBucket() {
        return null;
    }
}

