/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.GridConfigurada;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoColunaWeb;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.GridConfiguradaRN;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.PromptProdutoServicoGridService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Component;

@Component
public class PromptGridService {
    private static final String NOME_DEFAULT = "Default";
    private final PromptProdutoServicoGridService service;
    private final CacheService cacheService;
    private AbstractRegraNegocio<?, ?> rn;

    public PromptGridService(PromptProdutoServicoGridService service, CacheService cacheService) {
        this.service = service;
        this.cacheService = cacheService;
    }

    public AbstractRegraNegocio<?, ?> getRn() {
        return this.rn;
    }

    public void setRn(AbstractRegraNegocio<?, ?> rn) {
        this.rn = rn;
    }

    public Grid<?> getGrid(String cache, TipoRegistroProduto tipoProduto) throws UnicoMensagemUsuarioException {
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheService.get((Object)(cache = this.getCacheIdPerfil(cache)));
        if (wrapper != null) {
            return (Grid)wrapper.get();
        }
        return this.prepareGrid(cache, tipoProduto);
    }

    public List<Condicao> getCondicoesDefault(TipoRegistroProduto tipoProduto) {
        return this.service.getGrid(tipoProduto).getCondicoesDefault();
    }

    private Grid<?> prepareGrid(String cache, TipoRegistroProduto tipoProduto) throws UnicoMensagemUsuarioException {
        Grid grid = new Grid(this.service.getGrid(tipoProduto));
        GridBuilder gridBuilder = grid.getGridBuilder();
        GridConfigurada configuracaoGrid = this.getGridConfigurada(gridBuilder.getAliasTabela());
        if (configuracaoGrid != null) {
            List colunas = JsonUtil.fromJsonList((String)configuracaoGrid.getColunas(), RelatorioConfiguradoColunaWeb.class);
            if (!ListMapUtil.listNullOrEmpty((List)colunas)) {
                colunas.sort(Comparator.comparingInt(RelatorioConfiguradoColunaWeb::getPosicao));
                List colunasInvisiveis = gridBuilder.getColunasSql().stream().filter(colunaSQL -> !colunaSQL.isVisivel()).collect(Collectors.toList());
                List colunasConfiguradas = colunas.stream().map(colunaConfigurada -> this.colunaTabela2ColunaSQL(gridBuilder, colunaConfigurada, gridBuilder.getColunasSql())).collect(Collectors.toList());
                colunasConfiguradas.addAll(colunasInvisiveis);
                gridBuilder.setColunasSql(colunasConfiguradas);
                gridBuilder.carregarEnuns();
            }
        } else {
            List colunas = this.getColunasOriginais(gridBuilder);
            GridConfigurada gridConfigurada = new GridConfigurada(SessaoUtil.getSessao().getUsuario().getIdPerfil(), NOME_DEFAULT, this.rn.getTabela(), gridBuilder.getAliasTabela(), JsonUtil.toJson((Object)colunas));
            gridConfigurada.setAtual(true);
            GridConfiguradaRN.getInstance().gravar(0, gridConfigurada, SessaoUtil.getSessao());
        }
        grid.setGridBuilder(gridBuilder);
        this.cacheService.put((Object)cache, (Object)grid);
        this.cacheService.put((Object)cache.concat("_fields"), (Object)grid.getFieldsDefinition());
        return grid;
    }

    private GridConfigurada getGridConfigurada(String aliasTabela) {
        GridConfigurada configuracaoGrid = !StringUtil.stringNullOrEmpty((String)aliasTabela) ? GridConfiguradaRN.getInstance().buscarGridAtualPorPerfilAliasTabela(SessaoUtil.getSessao().getUsuario().getIdPerfil(), aliasTabela) : GridConfiguradaRN.getInstance().buscarGridAtualPorPerfilTabela(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela());
        return configuracaoGrid;
    }

    private ColunaSQL colunaTabela2ColunaSQL(GridBuilder<?> grid, RelatorioConfiguradoColunaWeb colunaGrid, List<ColunaSQL> colunasSqlOriginais) {
        ColunaSQL colunaSQL = new ColunaSQL(colunaGrid.getCodigo(), !Util.stringNullOrEmpty((String)colunaGrid.getAlias()) ? colunaGrid.getAlias() : colunaGrid.getCodigo());
        colunaSQL.setTamanho(colunaGrid.getTamanho());
        colunaSQL.setDescricao(colunaGrid.getDescricao());
        colunaSQL.setChavesEstrangeiras(colunaGrid.getChavesEstrangeiras());
        colunaSQL.setOrdem(colunaGrid.getPosicao());
        colunaSQL.setTotalizar(colunaGrid.isTotalizar());
        colunaSQL.setTipoDadoBase(colunaGrid.getTipoDado());
        colunaSQL.setVisivel(true);
        colunaSQL.setVirtual(colunaGrid.isVirtual());
        colunaSQL.setNaoUtilizarPesquisaRapida(colunaGrid.isNaoUtilizarPesquisaRapida());
        ColunaSQL colunaSQLOriginal = colunasSqlOriginais.stream().filter(c -> c.getAlias().equals(colunaSQL.getAlias())).findFirst().orElse(null);
        if (colunaSQLOriginal != null) {
            colunaSQL.setFormula(colunaSQLOriginal.getFormula());
            colunaSQL.setCoalesce(colunaSQLOriginal.getCoalesce());
            colunaSQL.setEscolha(colunaSQLOriginal.getEscolha());
            colunaSQL.setFuncao(colunaSQLOriginal.getFuncao());
            colunaSQL.setParametrosFuncao(colunaSQLOriginal.getParametrosFuncao());
            colunaSQL.setReferencia(colunaSQLOriginal.isReferencia());
            colunaSQL.setSelecao(colunaSQLOriginal.isSelecao());
            colunaSQL.setSubquery(colunaSQLOriginal.getSubquery());
            colunaSQL.setTotalizar(colunaSQLOriginal.isTotalizar());
            colunaSQL.setNaoAlterarValorEnum(colunaSQLOriginal.isNaoAlterarValorEnum());
            colunaSQL.setChavesEstrangeiras(colunaSQLOriginal.getChavesEstrangeiras());
            colunaSQL.setClasseValor(colunaSQLOriginal.getClasseValor());
            colunaSQL.setClasseEnum(colunaSQLOriginal.getClasseEnum());
            colunaSQL.setVirtual(colunaSQLOriginal.isVirtual());
            colunaSQL.setColunaSQLBuscarValorListener(colunaSQLOriginal.getColunaSQLBuscarValorListener());
            colunaSQL.setTipoJoin(colunaSQLOriginal.getTipoJoin());
        }
        if (colunaSQL.getClasseEnum() == null) {
            List fks = Util.array2List((Object[])colunaSQL.getChavesEstrangeiras());
            colunaSQL.setClasseEnum(grid.buscarClassEnum(this.rn.getTabela(), colunaSQL.getNome(), fks));
        }
        ColunaSQL colunaConfigurada = null;
        ColunaCustomizavelGrid colunaCustomizavel = grid.getColunaCustomizavel(colunaSQL);
        colunaConfigurada = colunaCustomizavel != null ? colunaCustomizavel.getColunaCustomizavel(colunaSQL) : this.rn.atualizaColunaSQLGrid(SessaoUtil.getSessao(), colunaSQL);
        if (colunaConfigurada.getTipoDadoBase() == null) {
            colunaConfigurada.setTipoDadoBase(colunaGrid.getTipoDado());
        }
        return colunaConfigurada;
    }

    private List<RelatorioConfiguradoColunaWeb> getColunasOriginais(GridBuilder<?> gridBuilder) {
        return gridBuilder.getColunasSql().stream().filter(ColunaSQL::isVisivel).map(colunaSQL -> {
            Coluna coluna = gridBuilder.getDefinicaoColuna(this.rn.getTabela(), colunaSQL);
            if (colunaSQL.getTipoDadoBase() == null) {
                colunaSQL.setTipoDadoBase(coluna.getTipoDado());
            }
            return new RelatorioConfiguradoColunaWeb(colunaSQL, coluna.getTipoDado());
        }).collect(Collectors.toList());
    }

    private String getCacheIdPerfil(String cache) {
        return cache.concat("_PERFIL_").concat(SessaoUtil.getSessao().getUsuario().getIdPerfil().toString());
    }
}

