/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.dashboard.widgets.vendas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.dashboard.VendasWidgetWrapper;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.dashboard.base.FiltroDashboard;
import br.intelidata.core.dashboard.base.services.VendasVendedorResumoWidgetService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.dashboard.base.WidgetController;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/vendas-vendedor-resumo-widget"})
public class VendasVendedorResumoWidgetController
extends WidgetController {
    private final VendasVendedorResumoWidgetService vendedorResumo;

    public VendasVendedorResumoWidgetController(VendasVendedorResumoWidgetService vendedorResumo) {
        this.vendedorResumo = vendedorResumo;
    }

    @RequestMapping(value={"/buscar-dados"})
    @DBAutoCommit
    public VendasWidgetWrapper buscarDados(@RequestParam Long idWidget, @RequestParam Long idVendedor) throws UnicoMensagemUsuarioException {
        FiltroDashboard objeto = new FiltroDashboard();
        objeto.setIdVendedor(idVendedor);
        this.gravarConfiguracao(idWidget, null, objeto);
        return this.vendedorResumo.buscarDados(idVendedor);
    }

    @RequestMapping(value={"/buscar-vendedor"})
    @DBAutoCommit
    public Map<Long, String> buscarVendedor() {
        Long idVendedor = null;
        Usuario usuario = SessaoUtil.getSessao().getUsuario();
        if (!usuario.isAdministrador() && usuario.getPreferenciaUsuario().isFiltrarFatVendedorUsuario() && !NumberUtil.longNullOuZero((Long)usuario.getIdEntidade())) {
            idVendedor = usuario.getIdEntidade();
        }
        return this.vendedorResumo.buscarVendedores(idVendedor);
    }
}

