/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.TipoRelatorioIReport;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ValidarIReportInterface;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.web.multipart.MultipartFile;

public interface ValidarIReportInterface {
    default public List<ArquivoIReport> validarArquivoIReport(List<MultipartFile> arquivosIReport) throws UnicoMensagemUsuarioException {
        ArrayList<ArquivoIReport> listaModeloImpressaoIReport = new ArrayList<ArquivoIReport>();
        try {
            ArquivoIReport arquivoPrincipal = null;
            for (MultipartFile file : arquivosIReport) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(file.getBytes());
                Throwable throwable = null;
                try {
                    JasperDesign jasperDesign = JRXmlLoader.load((InputStream)byteArrayInputStream);
                    boolean possuiSub = jasperDesign.getParametersList().stream().anyMatch(par -> par.getName().toLowerCase().startsWith("subreport_uniplus_"));
                    if ((arquivosIReport.size() <= 1 || !possuiSub) && (arquivosIReport.size() != 1 || possuiSub)) continue;
                    arquivoPrincipal = new ArquivoIReport(file, jasperDesign, null, TipoRelatorioIReport.RELATORIO);
                    break;
                }
                catch (Throwable jasperDesign) {
                    throwable = jasperDesign;
                    throw jasperDesign;
                }
                finally {
                    if (byteArrayInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    byteArrayInputStream.close();
                }
            }
            if (arquivoPrincipal == null) {
                throw new UnicoMensagemUsuarioException("COM279893", "N\u00e3o foi encontrado um arquivo iReport principal. Verifique.");
            }
            int qtdSubrelatorios = arquivoPrincipal.getJasperDesign().getParametersList().stream().filter(par -> par.getName().toLowerCase().startsWith("subreport_uniplus_")).mapToInt(par -> 1).sum();
            if (qtdSubrelatorios > 0) {
                for (JRParameter parameter : arquivoPrincipal.getJasperDesign().getParameters()) {
                    if (!parameter.getName().toLowerCase().startsWith("subreport_uniplus_")) continue;
                    ArquivoIReport arquivoSubRelatorio = null;
                    for (MultipartFile file : arquivosIReport) {
                        if (file.getOriginalFilename() == null) continue;
                        String nomeArquivo = file.getOriginalFilename();
                        if (nomeArquivo.contains("|") || nomeArquivo.contains("\\|")) {
                            nomeArquivo = nomeArquivo.toLowerCase().split("\\|")[1];
                        }
                        String nomeParmetro = "subreport_uniplus_" + nomeArquivo.substring(0, nomeArquivo.indexOf("."));
                        if (!parameter.getName().toLowerCase().equalsIgnoreCase(nomeParmetro)) continue;
                        arquivoSubRelatorio = new ArquivoIReport(file, null, parameter.getName(), TipoRelatorioIReport.SUB_RELATORIO);
                        break;
                    }
                    if (arquivoSubRelatorio == null) {
                        throw new UnicoMensagemUsuarioException("COM279894", "N\u00e3o foi encontrado um arquivo iReport para o sub-relat\u00f3rio " + parameter.getName() + ". Verifique.");
                    }
                    listaModeloImpressaoIReport.add(arquivoSubRelatorio);
                }
                if (qtdSubrelatorios != listaModeloImpressaoIReport.size()) {
                    throw new UnicoMensagemUsuarioException("COM279895", "N\u00e3o foram encontrados todos os arquivosIReport para os sub-relat\u00f3rios configurados nomeArquivo iReport principal.Faltaram " + (qtdSubrelatorios - listaModeloImpressaoIReport.size()) + " arquivos. Verifique.");
                }
            }
            listaModeloImpressaoIReport.add(0, arquivoPrincipal);
            return listaModeloImpressaoIReport;
        }
        catch (UnicoMensagemUsuarioException unicoMensagemUsuarioException) {
            throw unicoMensagemUsuarioException;
        }
        catch (Throwable ex) {
            throw new UnicoMensagemUsuarioException("COM279896", "N\u00e3o foi poss\u00edvel ler os arquivos iReport", ex);
        }
    }
}

