/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.prompt;

import br.intelidata.commons.core.prompt.FiltroListener;
import br.intelidata.commons.core.sql.DicionarioDados;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.Tabela;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PromptController<E, RN extends AbstractRegraNegocio<?, ?>> {
    private GridBuilder<RN> gridBuilder;
    private final List<FiltroListener> filtroListeners;
    private final ColunaSQL colunaPrincipal;
    private List<ColunaSQL> colunasSecundarias;
    private final List<Referencia> referencias;
    private final List<Condicao> condicoes;
    private final List<Referencia> referenciasDefault;
    private final List<Condicao> condicoesDefault;
    private final RN regraNegocio;
    private E objeto;
    private Boolean achouMaisDeUmRegistro;

    public PromptController(RN regraNegocio, ColunaSQL colunaPrincipal, ColunaSQL ... colunasSecundarias) {
        this.regraNegocio = regraNegocio;
        this.colunaPrincipal = colunaPrincipal;
        if (colunasSecundarias != null) {
            this.colunasSecundarias = Arrays.asList(colunasSecundarias);
        }
        this.filtroListeners = new ArrayList();
        this.referencias = new ArrayList();
        this.condicoes = new ArrayList();
        this.referenciasDefault = new ArrayList();
        this.condicoesDefault = new ArrayList();
        this.adicionaFiltrosPadrao();
    }

    protected void adicionaFiltrosPadrao() {
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!ListMapUtil.listNullOrEmpty((List)this.colunasSecundarias)) {
            for (ColunaSQL colunaSQL : this.colunasSecundarias) {
                this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void addFiltro(FiltroListener filtroListener) {
        this.filtroListeners.add(filtroListener);
    }

    public GridBuilder<RN> getGridBuilder() {
        if (this.gridBuilder == null) {
            throw new RuntimeException("GridBuilder indefinido");
        }
        return this.gridBuilder;
    }

    public void setGridBuilder(GridBuilder<RN> gridBuilder) {
        this.gridBuilder = gridBuilder;
    }

    public E getObjeto() {
        return (E)this.objeto;
    }

    public void executaFiltros(String valorPesquisado) {
        this.achouMaisDeUmRegistro = null;
        this.objeto = null;
        for (FiltroListener filtroListener : new ArrayList(this.filtroListeners)) {
            USelect select = this.createSelect();
            Condicao condicao = filtroListener.getFiltro(valorPesquisado);
            if (condicao != null && this.isCondicaoValida(condicao, valorPesquisado)) {
                select.add(condicao);
            } else {
                List condicoes = filtroListener.getFiltros(valorPesquisado);
                if (ListMapUtil.listNullOrEmpty((List)condicoes)) continue;
                condicoes.forEach(cond -> {
                    if (this.isCondicaoValida(condicao, valorPesquisado)) {
                        select.add(cond);
                    }
                });
            }
            int count = 0;
            Long id = null;
            Sql sql = new Sql(select);
            sql.executaQuery();
            while (sql.next()) {
                id = sql.getLong("id");
                ++count;
            }
            sql.close();
            if (count > 1) {
                this.achouMaisDeUmRegistro = true;
                break;
            }
            if (id == null) continue;
            this.achouMaisDeUmRegistro = false;
            this.objeto = this.buscarObjeto(id);
            break;
        }
    }

    protected E buscarObjeto(Long id) {
        AbstractPojo objeto = this.regraNegocio.buscarPorId(id);
        return (E)objeto;
    }

    private boolean isCondicaoValida(Condicao condicao, String valorPesquisado) {
        Coluna coluna;
        Tabela tabela = DicionarioDados.getInstance().getTabela(this.gridBuilder.getTabela());
        if (tabela != null && condicao != null && (coluna = tabela.getColuna(condicao.getAliasCondicao())) != null) {
            return !Number.class.isAssignableFrom(coluna.getTipoDado().getClasseJava()) || !NumberUtil.apenasNumeros((String)valorPesquisado).isEmpty();
        }
        return true;
    }

    private USelect createSelect() {
        USelect select = new USelect(this.getGridBuilder().getTabela());
        select.add(new ColunaSQL("id"));
        select.add(this.colunaPrincipal);
        if (this.colunasSecundarias != null) {
            for (ColunaSQL colunaSecundaria : this.colunasSecundarias) {
                select.add(colunaSecundaria);
            }
        }
        for (Referencia referencia : this.referenciasDefault) {
            select.add((ColunaSQL)referencia);
        }
        for (Condicao condicao : this.condicoesDefault) {
            select.add(condicao);
        }
        for (Referencia referencia : this.referencias) {
            select.add((ColunaSQL)referencia);
        }
        for (Condicao condicao : this.condicoes) {
            select.add(condicao);
        }
        return select;
    }

    public Boolean isAchouMaisDeUmRegistro() {
        return this.achouMaisDeUmRegistro;
    }

    public String getValorColunaPrincipal(E objeto) {
        return StringUtil.all2Atring((Object)BeanUtil.get(objeto, (String)this.colunaPrincipal.getNome(), (Object[])new Object[0]));
    }

    public void addReferencia(Referencia referencia) {
        this.referencias.add(referencia);
    }

    public void setReferencia(Referencia referencia) {
        this.referencias.clear();
        this.referencias.add(referencia);
    }

    public void addCondicao(Condicao condicao) {
        this.condicoes.add(condicao);
    }

    public void setCondicao(Condicao condicao) {
        this.condicoes.clear();
        this.condicoes.add(condicao);
    }

    public void addReferenciaDefault(Referencia referencia) {
        this.referenciasDefault.add(referencia);
    }

    public void setReferenciaDefault(Referencia referencia) {
        this.limpaReferenciaDefault();
        this.addReferenciaDefault(referencia);
    }

    public void limpaReferenciaDefault() {
        this.referenciasDefault.clear();
    }

    public List<Condicao> getCondicoesDefault() {
        return this.condicoesDefault;
    }

    public void addCondicaoDefault(Condicao condicao) {
        this.condicoesDefault.add(condicao);
    }

    public void limparCondicoesDefault() {
        this.condicoesDefault.clear();
    }

    public void limparCondicoes() {
        this.condicoes.clear();
    }

    public void limparReferencias() {
        this.referencias.clear();
    }

    public void clearFiltros() {
        this.filtroListeners.clear();
    }

    public ColunaSQL getColunaPrincipal() {
        return this.colunaPrincipal;
    }

    public List<ColunaSQL> getColunasSecundarias() {
        return this.colunasSecundarias;
    }

    static /* synthetic */ ColunaSQL access$000(PromptController x0) {
        return x0.colunaPrincipal;
    }
}

