/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;
import unichef.integracao.goomer.AtualizadorContaGoomer;
import unichef.pojo.ContaCliente;
import unichef.pojo.ControleContaIntegracao;
import unichef.regranegocio.ContaClienteRN;
import unichef.regranegocio.ControleContaIntegracaoRN;

public class ContaIntegracaoScheduler
extends AbstractPrepareScheduler {
    public ContaIntegracaoScheduler() {
        super(TipoJob.CONTA_INTEGRACAO.getDescricao(), Cron.every15seconds(), TipoJob.CONTA_INTEGRACAO);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void execute() throws Exception {
        Sessao sessao = ContextoHolder.getHolderSessaoScheduler();
        List controles = ControleContaIntegracaoRN.getInstance().buscarListaParaProcessar();
        for (ControleContaIntegracao controle : controles) {
            ContaCliente conta = ContaClienteRN.getInstance().buscarPorHashCompleta(controle.getHashConta());
            AtualizadorContaGoomer.atualizarConta((ContaCliente)conta, (Sessao)sessao);
            ControleContaIntegracaoRN.getInstance().excluir((AbstractPojo)controle, sessao);
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return AtualizadorContaGoomer.isHabilitado((Filial)ContextoHolder.getHolderSessaoScheduler().getFilial());
    }
}

