/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
implements Runnable {
    private IConnectionHandler connectionHandler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String tenant;
    private String nome;
    private Long jobId;
    private Long idUsuario;
    private Long idFilial;
    private LocalDateTime dataHoraInicio;
    private LocalDateTime dataHoraFim;

    public Job(String nome, String tenant, Long idUsuario, Long idFilial) {
        this.nome = nome;
        this.tenant = tenant;
        this.idUsuario = idUsuario;
        this.idFilial = idFilial;
    }

    public abstract void execute() throws Exception;

    public Sessao getSessao() {
        return Sessao.createSessao((Long)this.idUsuario, (Long)this.idFilial);
    }

    public Long getIdUsuario() {
        return this.idUsuario;
    }

    public Long getIdFilial() {
        return this.idFilial;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public LocalDateTime getDataHoraInicio() {
        return this.dataHoraInicio;
    }

    public LocalDateTime getDataHoraFim() {
        return this.dataHoraFim;
    }

    protected String getNome() {
        return this.nome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        TenantService tenantService = (TenantService)BeanUtil.getBean((String)"tenantService");
        ContextoHolder.setTenant((String)this.tenant, (String)tenantService.getDatabase(this.tenant));
        MDCConfigService mdcConfigService = (MDCConfigService)BeanUtil.getBean((String)"MDCConfigService");
        mdcConfigService.confiMDC(this.tenant);
        this.getConnectionHandler();
        try {
            this.connectionHandler.createConnection(false);
            this.connectionHandler.beginTransaction();
            Bridge.getBridge().initCache();
            this.prepare();
            this.dataHoraInicio = DataHoraFactory.getDataHora();
            this.execute();
            this.dataHoraFim = DataHoraFactory.getDataHora();
            this.success();
            this.connectionHandler.commit();
            this.log.info("Feito commit job");
            JobExecutorService jobExecutorService = (JobExecutorService)BeanUtil.getBean((String)"jobExecutorService");
            this.agendarOutrosJobs(jobExecutorService);
        }
        catch (Exception ex) {
            try {
                this.log.error(this.nome + "(" + this.jobId + ")falhou ", (Throwable)ex);
                if (this.connectionHandler.isConnected()) {
                    this.connectionHandler.rollback();
                }
                this.dataHoraFim = DataHoraFactory.getDataHora();
                this.error(ex);
            }
            catch (Exception ex2) {
                this.log.error(this.nome + "(" + this.jobId + ") rollback falhou", (Throwable)ex2);
            }
        }
        finally {
            Bridge.getBridge().remove();
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
        }
    }

    private void prepare() throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)this.idUsuario)) {
            throw new UnicoMensagemUsuarioException("WWW525", "Usu\u00e1rio n\u00e3o definido para o job " + this.getNome());
        }
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(this.idUsuario);
        if (NumberUtil.longNullOuZero((Long)this.idFilial)) {
            this.idFilial = usuario.getIdFilialTrabalho();
        }
        SessaoUtil.setSessaoJob((Sessao)Sessao.createSessao((Long)this.idUsuario, (Long)this.idFilial));
    }

    void success() throws Exception {
    }

    public void agendarOutrosJobs(JobExecutorService jobExecutorService) {
    }

    void error(Exception ex) throws Exception {
    }

    protected IConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = (IConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
        }
        return this.connectionHandler;
    }
}

