/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public abstract class JobSpedSintegra
extends AbstractPrepareJob {
    protected Remessa remessa;
    protected String nomeArquivo;
    protected boolean temErro;

    public JobSpedSintegra(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    protected File getFile() throws IOException {
        File scratchFile;
        block29: {
            scratchFile = null;
            if (this.remessa != null) {
                if (this.temErro) {
                    scratchFile = new File(FileUtils.getTempDirectory().getAbsolutePath(), this.nomeArquivo + ".zip");
                    scratchFile.deleteOnExit();
                    try (FileOutputStream fos = new FileOutputStream(scratchFile);
                         ZipOutputStream zipOut = new ZipOutputStream(fos);){
                        for (Map.Entry entry : this.remessa.getMalote().getMapArquivos().entrySet()) {
                            if (entry.getValue() instanceof File) {
                                FileUtil.comprimirArquivoEmDisco((ZipOutputStream)zipOut, (File)((File)entry.getValue()), (String)(this.nomeArquivo + ".txt"));
                                continue;
                            }
                            FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])((byte[])entry.getValue()), (String)"Erros.pdf");
                        }
                        break block29;
                    }
                }
                File fileDest = new File(FileUtils.getTempDirectory().getAbsolutePath(), this.nomeArquivo + ".txt");
                scratchFile = (File)this.remessa.getMalote().getMapArquivos().get(new ArrayList(this.remessa.getMalote().getMapArquivos().keySet()).get(0));
                boolean renomeou = scratchFile.renameTo(fileDest);
                if (renomeou) {
                    return fileDest;
                }
                return scratchFile;
            }
        }
        return scratchFile;
    }
}

