/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ajusteestoque;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.AjusteEstoque;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.CustoInterface;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.MotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.MovimentacaoMotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoContagemEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.estoque.OrigemAjusteEstoqueContagemRealizada;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.custo.regranegocio.CustoFactory;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueContagemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueRN;
import br.intelidata.commons.modulo.estoque.regranegocio.MotivoAjusteEstoqueRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNumeroSerieRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImpressaoCrudWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ajusteestoque.AjusteEstoqueWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ConfiguracaoCampoExtra(TABELA="inventarioestoque", QUANTIDADE=QuantidadeCampoExtra.AJUSTE_ESTOQUE)
@RestController
@RequestMapping(value={"/api/ajustes-estoque"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Ajustes de estoque", ICONE="icon-local-estoque", ROTA="/estoques/ajustes-estoque", PROGRAMA=307)
public class AjusteEstoqueCrudController
extends ItemKitController<AjusteEstoque, AjusteEstoqueItem, AjusteEstoqueRN> {
    @Autowired
    public AjusteEstoqueCrudController() {
        super((AbstractRegraNegocio)AjusteEstoqueRN.getInstance(), AjusteEstoque::new, true, true);
        this.setItemSupplier(AjusteEstoqueItem::new);
    }

    public Long update(AjusteEstoque ajusteEstoque, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW119", "M\u00e9todo n\u00e3o implementado para Ajustes de estoque. Verifique!");
    }

    protected void beforeImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        uViewer.getVisualizador().setTitulo("Ajuste de estoque - " + impressaoCrudWrapper.getDados().get("codigo"));
    }

    protected void afterImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        if (impressaoCrudWrapper.getDados().containsKey("listaInventarioEstoqueItem")) {
            Long idMotivo = Util.string2Long((String)Util.all2Atring(impressaoCrudWrapper.getDados().get("idMotivo")));
            MotivoAjusteEstoque motivo = (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(idMotivo);
            boolean quantidadeValorOuSomenteValor = motivo != null && motivo.getMovimentacao().in(new AbstractEnum[]{MovimentacaoMotivoAjusteEstoque.QUANTIDADE_E_VALOR, MovimentacaoMotivoAjusteEstoque.SOMENTE_VALOR});
            uViewer.saltaLinha();
            if (quantidadeValorOuSomenteValor) {
                uViewer.inicioNivel(new int[]{10, 30, 10, 15, 15, 15, 15});
            } else {
                uViewer.inicioNivel(new int[]{10, 30, 10, 20, 20, 15});
            }
            uViewer.inicioTitulo();
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("UN", false);
            uViewer.escreveTitulo("Emb.", true);
            uViewer.escreveTitulo("Quantidade", true);
            if (quantidadeValorOuSomenteValor) {
                uViewer.escreveTitulo("Custo unit\u00e1rio", true);
            }
            uViewer.escreveTitulo("Total", true);
            uViewer.fimTitulo();
            List listaItens = (List)impressaoCrudWrapper.getDados().get("listaInventarioEstoqueItem");
            for (Map mapItem : listaItens) {
                uViewer.inicioLinha();
                uViewer.escreveColuna((String)mapItem.get("codigoProduto"));
                uViewer.escreveColuna((String)mapItem.get("descricaoProduto"));
                uViewer.escreveColuna((String)mapItem.get("unidadeMedida"));
                uViewer.escreveColuna(((Integer)mapItem.get("fatorConversao")).intValue());
                int casasDecimais = mapItem.get("casasDecimaisUN") != null ? (Integer)mapItem.get("casasDecimaisUN") : 2;
                uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidade"), casasDecimais));
                if (quantidadeValorOuSomenteValor) {
                    int casasDecimaisCusto = mapItem.get("casasDecimaisCusto") != null ? (Integer)mapItem.get("casasDecimaisCusto") : 2;
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("preco"), casasDecimaisCusto));
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("total"), 2));
                } else {
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidadeTotal"), casasDecimais));
                }
                uViewer.fimLinha();
                if (!mapItem.containsKey("filhosKit")) continue;
                List listaItensKit = (List)mapItem.get("filhosKit");
                for (Map mapItemKit : listaItensKit) {
                    uViewer.inicioLinha();
                    uViewer.escreveColuna("  " + mapItemKit.get("codigoProduto"));
                    uViewer.escreveColuna((String)mapItemKit.get("descricaoProduto"));
                    uViewer.escreveColuna((String)mapItemKit.get("unidadeMedida"));
                    uViewer.escreveColuna(((Integer)mapItemKit.get("fatorConversao")).intValue());
                    int casasDecimaisKit = mapItemKit.get("casasDecimaisUN") != null ? (Integer)mapItem.get("casasDecimaisUN") : 2;
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("quantidade"), casasDecimaisKit));
                    if (quantidadeValorOuSomenteValor) {
                        int casasDecimaisCusto = mapItemKit.get("casasDecimaisCusto") != null ? (Integer)mapItemKit.get("casasDecimaisCusto") : 2;
                        uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("preco"), casasDecimaisCusto));
                        uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("total"), 2));
                    } else {
                        uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("quantidadeTotal"), casasDecimais));
                    }
                    uViewer.fimLinha();
                }
            }
            uViewer.fimNivel();
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    @DBTransaction
    public Long updateAjuste(@RequestBody AjusteEstoque ajusteEstoque) throws UnicoMensagemUsuarioException {
        AjusteEstoque ajuste = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoque.getId());
        if (ajuste == null) {
            throw new UnicoMensagemUsuarioException("WWW118", "Registro n\u00e3o encontrado");
        }
        ajuste.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        ajuste.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        ajuste.setStatus(StatusAjusteEstoque.PENDENTE);
        ajuste.setObservacao(ajusteEstoque.getObservacao());
        AjusteEstoqueRN.getInstance().alterar((AbstractPojo)ajuste, SessaoUtil.getSessao());
        return ajuste.getId();
    }

    @PostMapping(value={"/adicionar-item"})
    @DBTransaction
    public AjusteEstoque adcionarItem(@RequestBody AjusteEstoqueWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        wrapper.setItens(this.separarItensKit(wrapper.getItens()));
        if (wrapper.isContagem()) {
            if (!TipoContagemEstoque.TOTAL.equals((Object)wrapper.getTipoContagem()) && ListMapUtil.listNullOrEmpty((List)wrapper.getContagens())) {
                if (TipoContagemEstoque.PRODUTO.equals((Object)wrapper.getTipoContagem())) {
                    throw new UnicoMensagemUsuarioException("EST122", "Informe um ou mais produtos na aba 'Contagem' antes de incluir os produtos para contagem.");
                }
                if (TipoContagemEstoque.GRUPO.equals((Object)wrapper.getTipoContagem())) {
                    throw new UnicoMensagemUsuarioException("EST151", "Informe um ou mais grupos na aba 'Contagem' antes de incluir os produtos para contagem.");
                }
                if (TipoContagemEstoque.FORNECEDOR.equals((Object)wrapper.getTipoContagem())) {
                    throw new UnicoMensagemUsuarioException("EST152", "Informe um ou mais fornecedores na aba 'Contagem' antes de incluir os produtos para contagem.");
                }
                if (TipoContagemEstoque.FAMILIA.equals((Object)wrapper.getTipoContagem())) {
                    throw new UnicoMensagemUsuarioException("EST153", "Informe uma ou mais fam\u00edlias na aba 'Contagem' antes de incluir os produtos para contagem.");
                }
            }
            if (!Util.listNullOrEmpty((List)wrapper.getItensEdi())) {
                for (AjusteEstoqueItem ajusteEstoqueItem : wrapper.getItensEdi()) {
                    AjusteEstoqueContagemRN.getInstance().validarContagem(wrapper.getTipoContagem(), wrapper.getContagens(), ajusteEstoqueItem.getIdProduto(), ajusteEstoqueItem.getTipoKit());
                }
            } else {
                AjusteEstoqueContagemRN.getInstance().validarContagem(wrapper.getTipoContagem(), wrapper.getContagens(), wrapper.getItem().getIdProduto(), wrapper.getItem().getTipoKit());
            }
            wrapper.getAjusteEstoque().setTipoMovimento(TipoAjusteEstoque.CONTAGEM);
        }
        this.gravarAjusteEstoque(sessao, wrapper.getAjusteEstoque());
        if (!Util.listNullOrEmpty((List)wrapper.getItensEdi())) {
            Iterator iterator = wrapper.getItensEdi().iterator();
            while (iterator.hasNext()) {
                AjusteEstoqueItem ajusteEstoqueItem;
                ajusteEstoqueItem.setPossuiLote(!Util.listNullOrEmpty((List)(ajusteEstoqueItem = (AjusteEstoqueItem)iterator.next()).getLotes()));
                this.incluirNovoItem(sessao, wrapper.getAjusteEstoque(), ajusteEstoqueItem, wrapper.getOrigem(), false, wrapper.isAgrupar(), wrapper.isContagem(), 0, wrapper.getItens());
            }
        } else {
            if (wrapper.getItem() != null) {
                wrapper.getItem().setPossuiLote(!Util.listNullOrEmpty((List)wrapper.getItem().getLotes()));
            }
            if (wrapper.getItem() != null && NumberUtil.longNullOuZero((Long)wrapper.getItem().getId()) || wrapper.isTrocouProduto()) {
                this.incluirNovoItem(sessao, wrapper.getAjusteEstoque(), wrapper.getItem(), wrapper.getOrigem(), wrapper.isTrocouProduto(), wrapper.isAgrupar(), wrapper.isContagem(), wrapper.getIdItem(), wrapper.getItens());
            } else {
                this.atualizarQuantidadeKitsFilhos(sessao, wrapper.getAjusteEstoque(), wrapper.getItem(), wrapper.getIdItem(), wrapper.getOrigem(), wrapper.getItens());
                this.gravarItemAjusteEstoque(sessao, wrapper.getAjusteEstoque(), wrapper.getItem(), wrapper.getOrigem());
            }
        }
        AjusteEstoque ajusteEstoqueRetorno = wrapper.getAjusteEstoque();
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(ajusteEstoqueRetorno.getId());
        Long idLocalEstoque = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE) ? ajusteEstoqueRetorno.getIdLocalEstoqueOrigem() : null;
        itens.forEach(item -> AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(sessao.getFilial().getId(), idLocalEstoque, Collections.singletonList(item)));
        ajusteEstoqueRetorno.setListaInventarioEstoqueItem(this.agruparItensKit(itens));
        return ajusteEstoqueRetorno;
    }

    @RequestMapping(value={"/agrupar-itens"}, method={RequestMethod.POST})
    @DBTransaction
    public AjusteEstoque agruparItens(@RequestBody AjusteEstoqueWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        wrapper.setItens(this.separarItensKit(wrapper.getItens()));
        ArrayList<AjusteEstoqueItem> retorno = new ArrayList<AjusteEstoqueItem>();
        for (AjusteEstoqueItem item : wrapper.getItens()) {
            AjusteEstoqueItem itemAgrupado = AjusteEstoqueItemRN.getInstance().agruparAjusteEstoqueItem(sessao, item, true, retorno);
            if (itemAgrupado != null) {
                retorno.set(retorno.indexOf(itemAgrupado), itemAgrupado);
                continue;
            }
            retorno.add(item);
        }
        wrapper.getItens().removeIf(it -> retorno.stream().anyMatch(it2 -> it.getId().equals(it2.getId())));
        for (AjusteEstoqueItem item : wrapper.getItens()) {
            this.removeInventarioEstoqueItem(sessao, wrapper.getAjusteEstoque(), item, wrapper.getItens(), wrapper.getItens().indexOf(item));
        }
        for (AjusteEstoqueItem item : retorno) {
            this.atualizarQuantidadeKitsFilhos(sessao, wrapper.getAjusteEstoque(), item, retorno.indexOf(item), OrigemAjusteEstoqueContagemRealizada.MANUAL, retorno);
            this.gravarItemAjusteEstoque(sessao, wrapper.getAjusteEstoque(), item, OrigemAjusteEstoqueContagemRealizada.MANUAL);
        }
        wrapper.getAjusteEstoque().setListaInventarioEstoqueItem(this.agruparItensKit(retorno));
        return wrapper.getAjusteEstoque();
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.PUT})
    @DBTransaction
    public void gravar(@RequestBody AjusteEstoque ajusteEstoque) throws UnicoMensagemUsuarioException {
        MotivoAjusteEstoque motivo;
        Sessao sessao = SessaoUtil.getSessao();
        this.gravarAjusteEstoque(sessao, ajusteEstoque);
        if (ajusteEstoque.getTipoMovimento().isPossuiMotivo() && NumberUtil.longNullOuZero((Long)ajusteEstoque.getIdMotivo())) {
            throw new UnicoMensagemUsuarioException("WEST51", "Informe o motivo de ajuste de estoque");
        }
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(ajusteEstoque.getId());
        if (ListMapUtil.listNullOrEmpty((List)itens)) {
            throw new UnicoMensagemUsuarioException("WWW120", "N\u00e3o foram encontrados itens para o Ajuste de estoque.");
        }
        MotivoAjusteEstoque motivoAjusteEstoque = motivo = !NumberUtil.longNullOuZero((Long)ajusteEstoque.getIdMotivo()) ? (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoque.getIdMotivo()) : null;
        if (motivo != null) {
            AjusteEstoqueItemRN.getInstance().carregaListaNumeroSerie(itens, motivo.getCodigo().intValue());
        } else {
            itens.stream().filter(item -> !StringUtil.stringNullOrEmpty((String)item.getNumerosSerie())).forEach(item -> item.setListaNumeroSeries(ProdutoNumeroSerieRN.getInstance().getListaNumeroSerie(item.getNumerosSerie())));
        }
        ajusteEstoque.setListaInventarioEstoqueItem(itens);
        this.gravarAuditoriaRegistro(ajusteEstoque.getId(), (AbstractPojo)ajusteEstoque, 1);
        if (!ajusteEstoque.isContagem()) {
            AjusteEstoqueRN.getInstance().processarAjusteEstoque(sessao, ajusteEstoque, itens);
        }
    }

    @RequestMapping(value={"/filtrar-pendente"})
    @DBAutoCommit
    public AjusteEstoque filtrarAjustePendente() {
        AjusteEstoque ajusteEstoque = AjusteEstoqueRN.getInstance().buscarAjustePendente(SessaoUtil.getSessao(), SessaoUtil.getSessao().getUsuario().getId(), false);
        if (ajusteEstoque == null) {
            ajusteEstoque = new AjusteEstoque();
        }
        return ajusteEstoque;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(id, null, 2);
        AjusteEstoqueRN.getInstance().excluirListaPendente(SessaoUtil.getSessao(), false);
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    @PostMapping(value={"/estornar"})
    @DBTransaction
    public boolean estornar(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        AjusteEstoque ajuste = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
        if (ajuste == null) {
            throw new UnicoMensagemUsuarioException("WEST34", "N\u00e3o foi poss\u00edvel estornar o documento");
        }
        if (StatusAjusteEstoque.ESTORNADO.equals((Object)ajuste.getStatus())) {
            throw new UnicoMensagemUsuarioException("WWW121", "Ajuste de estoque j\u00e1 estornado.");
        }
        boolean isEstornou = AjusteEstoqueRN.getInstance().estornar(SessaoUtil.getSessao(), id);
        if (!isEstornou) {
            throw new UnicoMensagemUsuarioException("WWW122", "N\u00e3o foi poss\u00edvel estornar o documento.");
        }
        AjusteEstoque ajusteEstoqueAlterado = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
        this.gravarAuditoriaRegistro(id, (AbstractPojo)ajusteEstoqueAlterado, 1);
        return isEstornou;
    }

    @RequestMapping(value={"/gerar-nf-controle-perdas"})
    @DBTransaction
    public String gerarNotaFiscalControlePerdas(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        AjusteEstoque ajuste = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
        if (ajuste == null) {
            throw new UnicoMensagemUsuarioException("WWW127", "N\u00e3o foi poss\u00edvel estornar o documento");
        }
        if (!ajuste.getStatus().equals((Object)StatusAjusteEstoque.FINALIZADO)) {
            throw new UnicoMensagemUsuarioException("WWW128", "S\u00f3 \u00e9 poss\u00edvel gerar nota para documentos finalizados.");
        }
        if (!NumberUtil.longNullOuZero((Long)ajuste.getIdNotaFiscalControlePerda())) {
            throw new UnicoMensagemUsuarioException("WWW129", "O documento j\u00e1 possui nota fiscal gerada");
        }
        MotivoAjusteEstoque motivoAjusteEstoque = (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(ajuste.getIdMotivo());
        if (motivoAjusteEstoque == null || !motivoAjusteEstoque.isControlePerda()) {
            throw new UnicoMensagemUsuarioException("WWW130", "Motivo de ajuste de estoque n\u00e3o configurado para controle de perda.");
        }
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().gravarNotaFiscalControlePerdaPorIdAjusteEstoque(SessaoUtil.getSessao(), id);
        return "NTF9007 - Nota fiscal n\u00famero " + notaFiscal.getNumeroNotaFiscal() + " gerada com sucesso";
    }

    @RequestMapping(value={"/buscar-saldo"})
    @DBAutoCommit
    public BigDecimal buscarSaldoEstoque(@RequestParam Long idProduto, @RequestParam Long idLocalEstoqueOrigem) {
        Long idLocalEstoque = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE) ? idLocalEstoqueOrigem : null;
        AjusteEstoqueItem item = new AjusteEstoqueItem();
        item.setIdProduto(idProduto);
        AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(SessaoUtil.getSessao().getFilial().getId(), idLocalEstoque, Collections.singletonList(item));
        return item.getSaldoEstoque();
    }

    public GridBuilder<AjusteEstoqueRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idfilial", "idfilial", 0, false));
        colunas.add(new ColunaSQL("data", "data_filtro", "Data filtro", 0, false, new String[0]));
        colunas.add(new ColunaSQL("status", "statusdefault", "Status Default", 0, false, new String[0]));
        colunas.add(new ColunaSQL("tipomovimento", "tipomovimentodefault", "", 10, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "Documento", 0, true));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00f5es", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 0, true, new String[]{"fk_inventarioestoque_usuario"}));
        colunas.add(new ColunaSQL("tipoMovimento", "Tipo", 0, true, TipoAjusteEstoque.class));
        colunas.add(new ColunaSQL("status", "Status", 0, true, StatusAjusteEstoque.class));
        GridBuilder gridBuilder = new GridBuilder(AjusteEstoqueRN.getInstance().getTabela(), colunas);
        gridBuilder.addReferenciaDefault(new Referencia("idFilial"));
        gridBuilder.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        gridBuilder.addCodicaoDefault(new Condicao("tipomovimentodefault", Operador.DIFERENTE, TipoAjusteEstoque.CONTAGEM.getId().intValue()));
        gridBuilder.addOrdemDefault(new Ordem("id", true));
        return gridBuilder;
    }

    protected String getCacheId() {
        return "ajustes-estoque".concat("_").concat(SessaoUtil.getSessao().getIdFilial().toString());
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        TipoAjusteEstoque tipo = null;
        if (parameters.containsKey((Object)"tipoMovimento")) {
            tipo = Enum.valueOf(TipoAjusteEstoque.class, StringUtil.getFirstMap(parameters, (String)"tipoMovimento"));
        }
        MotivoAjusteEstoque motivoAjusteEstoque = null;
        if (parameters.containsKey((Object)"idMotivo")) {
            motivoAjusteEstoque = (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(StringUtil.convertFirstValueMapToLong(parameters, (String)"idMotivo"));
        }
        ImportacaoDadosColetor importacao = new ImportacaoDadosColetor(AjusteEstoqueItem.class, idEdi, file, motivoAjusteEstoque != null ? motivoAjusteEstoque.getMovimentacao() : null, TipoAjusteEstoque.LEVANTAMENTO.equals((Object)tipo));
        importacao.importar();
        return importacao.getEDIProcessado();
    }

    public ProdutoItemWeb<AjusteEstoqueItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        AjusteEstoqueItem item = new AjusteEstoqueItem();
        item.setPossuiLote(produto.isPossuiLote());
        item.setIdProduto(produto.getId());
        item.setCodigoProduto(produto.getCodigo());
        item.setDescricaoProduto(produto.getNome());
        item.setIdUnidadeMedida(produto.getIdUnidadeMedida());
        item.setUnidadeMedida(produto.getUnidademedida());
        item.setQuantidade(BigDecimal.ONE);
        Sessao sessao = SessaoUtil.getSessao();
        AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(sessao.getFilial().getId(), Long.valueOf(0L), Collections.singletonList(item));
        CustoInterface custo = CustoFactory.getCusto((Long)produto.getId(), (Filial)SessaoUtil.getSessao().getFilial());
        item.setPreco(custo.getCusto());
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        return produtoItem;
    }

    @RequestMapping(value={"/buscar-itens"})
    @DBAutoCommit
    public List<AjusteEstoqueItem> buscarItensAjuste(@RequestParam Long idAjuste) {
        AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(idAjuste);
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(idAjuste);
        if (ListMapUtil.listNullOrEmpty((List)itens)) {
            return itens;
        }
        MotivoAjusteEstoque motivoAjusteEstoque = (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoque.getIdMotivo());
        if (motivoAjusteEstoque != null) {
            AjusteEstoqueItemRN.getInstance().carregaListaNumeroSerie(itens, motivoAjusteEstoque.getCodigo().intValue());
        } else {
            itens.stream().filter(item -> !StringUtil.stringNullOrEmpty((String)item.getNumerosSerie())).forEach(item -> item.setListaNumeroSeries(ProdutoNumeroSerieRN.getInstance().getListaNumeroSerie(item.getNumerosSerie())));
        }
        HashMap produtos = ProdutoRN.getInstance().getProdutosAjusteEstoque(itens.stream().map(AjusteEstoqueItem::getIdProduto).collect(Collectors.toList()));
        Sessao sessao = SessaoUtil.getSessao();
        itens.forEach(item -> {
            Produto produto = (Produto)produtos.get(item.getIdProduto());
            if (produto != null) {
                item.setCodigoProduto(produto.getCodigo());
                item.setDescricaoProduto(produto.getNome());
                item.setUnidadeMedida(produto.getUnidadeMedida());
                Unidademedida unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida());
                item.setCasasDecimaisUN(Integer.valueOf(unidadeMedida != null ? unidadeMedida.getCasasdecimais() : 0));
                item.setQuantidade(item.getQuantidade().setScale((int)item.getCasasDecimaisUN(), RoundingMode.HALF_EVEN));
                item.setTotal(item.getTotal().setScale(2, RoundingMode.HALF_EVEN));
                AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(sessao.getFilial().getId(), ajusteEstoque.getIdLocalEstoqueOrigem(), Collections.singletonList(item));
            }
        });
        List retorno = this.agruparItensKit(itens);
        retorno.sort(Comparator.comparing(AjusteEstoqueItem::getId));
        return retorno;
    }

    @PostMapping(value={"/excluir-item"})
    @DBTransaction
    public void deleteItem(@RequestBody AjusteEstoqueWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.removeInventarioEstoqueItem(SessaoUtil.getSessao(), wrapper.getAjusteEstoque(), wrapper.getItem(), wrapper.getItens(), wrapper.getIdItem());
    }

    private void gravarAjusteEstoque(Sessao sessao, AjusteEstoque ajusteEstoque) throws UnicoMensagemUsuarioException {
        ajusteEstoque.setIdUsuario(sessao.getIdUsuario());
        ajusteEstoque.setIdFilial(sessao.getIdFilial());
        ajusteEstoque.setStatus(StatusAjusteEstoque.PENDENTE);
        if (Util.longNullOuZero((Long)ajusteEstoque.getId())) {
            ajusteEstoque.setCodigo(AjusteEstoqueRN.getInstance().getCodigoUnico(sessao));
            Long id = AjusteEstoqueRN.getInstance().gravar(0, ajusteEstoque, sessao);
            ajusteEstoque.setId(id);
        } else {
            AjusteEstoqueRN.getInstance().gravar(1, ajusteEstoque, sessao);
        }
    }

    private void gravarItemAjusteEstoque(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem ajusteEstoqueItem, OrigemAjusteEstoqueContagemRealizada origem) throws UnicoMensagemUsuarioException {
        this.gravarAjusteEstoque(sessao, ajusteEstoque);
        ajusteEstoqueItem.setIdInventarioEstoque(ajusteEstoque.getId());
        if (Util.longNullOuZeroOuNegativo((Long)ajusteEstoqueItem.getId())) {
            Long id = AjusteEstoqueItemRN.getInstance().gravar(0, ajusteEstoque, ajusteEstoqueItem, sessao, origem);
            ajusteEstoqueItem.setId(id);
        } else {
            AjusteEstoqueItemRN.getInstance().gravar(1, ajusteEstoque, ajusteEstoqueItem, sessao, origem);
        }
        ajusteEstoque.setListaInventarioEstoqueItem(AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(ajusteEstoque.getId()));
        this.gravarAuditoriaRegistro(ajusteEstoque.getId(), (AbstractPojo)ajusteEstoque, 1);
    }

    private void adicionaKit(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem item, OrigemAjusteEstoqueContagemRealizada origem, List<AjusteEstoqueItem> itens, boolean agrupar) throws UnicoMensagemUsuarioException {
        AjusteEstoqueItemRN.getInstance().adicionaKitsFilhos(sessao, item, agrupar, itens, ajusteEstoque.getIdLocalEstoqueOrigem());
        this.gravarItemAjusteEstoque(sessao, ajusteEstoque, item, origem);
        for (AjusteEstoqueItem itemKit : item.getFilhosKit()) {
            itemKit.setIdInventarioEstoque(ajusteEstoque.getId());
            this.gravarItemAjusteEstoque(sessao, ajusteEstoque, itemKit, OrigemAjusteEstoqueContagemRealizada.MANUAL);
        }
    }

    private void atualizarQuantidadeKitsFilhos(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem kitPai, int idItem, OrigemAjusteEstoqueContagemRealizada origem, List<AjusteEstoqueItem> itens) throws UnicoMensagemUsuarioException {
        if (kitPai.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) {
            AjusteEstoqueItemRN.getInstance().atualizarQuantidadeKitsFilhos(Contexto.getInstance().getSessao(), kitPai, idItem, itens);
            for (AjusteEstoqueItem item : kitPai.getFilhosKit()) {
                this.gravarItemAjusteEstoque(sessao, ajusteEstoque, item, origem);
            }
        }
    }

    private void incluirNovoItem(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem ajusteEstoqueItem, OrigemAjusteEstoqueContagemRealizada origem, boolean trocouProduto, boolean agruparProduto, boolean contagem, int idItem, List<AjusteEstoqueItem> itens) throws UnicoMensagemUsuarioException {
        AjusteEstoqueItem ajusteEstoqueAgrupador = AjusteEstoqueItemRN.getInstance().agruparAjusteEstoqueItem(sessao, ajusteEstoqueItem, agruparProduto, itens);
        if (ajusteEstoqueAgrupador != null) {
            this.gravarItemAjusteEstoque(sessao, ajusteEstoque, ajusteEstoqueAgrupador, origem);
            this.atualizarQuantidadeKitsFilhos(sessao, ajusteEstoque, ajusteEstoqueAgrupador, idItem, origem, itens);
        } else {
            if (contagem && OrigemAjusteEstoqueContagemRealizada.COLETOR.equals((Object)origem)) {
                AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(sessao.getFilial().getId(), ajusteEstoque.getIdLocalEstoqueOrigem(), Collections.singletonList(ajusteEstoqueItem));
            }
            if (TipoKit.KIT_PAI.getId().intValue() == ajusteEstoqueItem.getTipoKit()) {
                this.adicionaKit(sessao, ajusteEstoque, ajusteEstoqueItem, origem, itens, agruparProduto);
            } else {
                this.gravarItemAjusteEstoque(sessao, ajusteEstoque, ajusteEstoqueItem, origem);
            }
        }
        if (trocouProduto) {
            this.removeInventarioEstoqueItem(sessao, ajusteEstoque, itens.get(idItem), itens, idItem);
        }
    }

    private void removeInventarioEstoqueItem(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem item, List<AjusteEstoqueItem> itens, int idItem) throws UnicoMensagemUsuarioException {
        if (item.getTipoKit() != TipoKit.KIT_COMPONENTE.getId().intValue()) {
            ArrayList<AjusteEstoqueItem> listaRemover = new ArrayList<AjusteEstoqueItem>();
            listaRemover.add(item);
            if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) {
                AjusteEstoqueItem proximoItem;
                for (int i = idItem + 1; i < itens.size() && (proximoItem = itens.get(i)).getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue(); ++i) {
                    listaRemover.add(proximoItem);
                }
            }
            for (AjusteEstoqueItem itemRemover : listaRemover) {
                this.excluirItemInventarioEstoque(sessao, ajusteEstoque, itemRemover);
            }
        }
    }

    private void excluirItemInventarioEstoque(Sessao sessao, AjusteEstoque ajusteEstoque, AjusteEstoqueItem item) throws UnicoMensagemUsuarioException {
        AjusteEstoqueItemRN.getInstance().gravar(2, ajusteEstoque, item, sessao, OrigemAjusteEstoqueContagemRealizada.MANUAL);
        this.gravarAuditoriaRegistro(ajusteEstoque.getId(), (AbstractPojo)ajusteEstoque, 2);
    }

    protected boolean isCalcularRateioValoreKit() {
        return false;
    }
}

