/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.balanca;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.periferico.balanca.MarcaBalanca;
import br.intelidata.commons.core.periferico.balanca.ModeloBalanca;
import br.intelidata.commons.core.periferico.balanca.Serial;
import br.intelidata.commons.core.util.UnicoBalancaProperties;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.balanca.BalancaWrapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/balanca"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Configura\u00e7\u00e3o da balan\u00e7a", ROTA="/ferramentas/balanca", ICONE="icon-balanca-configura2", PROGRAMA=522)
public class BalancaSimpleController
extends SimpleCrudController {
    public BalancaWrapper get(Long parentId) throws UnicoMensagemUsuarioException {
        String configuracao;
        int marcaBalanca = UnicoBalancaProperties.getInstance().getInt("Balanca.Marca");
        String portaSerial = UnicoBalancaProperties.getInstance().getString("Balanca.PortaSerial");
        int modelo = UnicoBalancaProperties.getInstance().getInt("Balanca.Modelo");
        int dividirPor = UnicoBalancaProperties.getInstance().getInt("Balanca.DividirPor");
        int multiplicarPor = UnicoBalancaProperties.getInstance().getInt("Balanca.MultiplicarPor");
        String baudRate = UnicoBalancaProperties.getInstance().getString("Balanca.Baudrate");
        String parity = UnicoBalancaProperties.getInstance().getString("Balanca.Parity");
        String dataBits = UnicoBalancaProperties.getInstance().getString("Balanca.Databits");
        String stopBits = UnicoBalancaProperties.getInstance().getString("Balanca.Stopbits");
        Serial serial = new Serial(baudRate, parity, dataBits, stopBits);
        if (StringUtil.stringNullOrEmpty((String)portaSerial)) {
            portaSerial = "COM1";
        }
        if (dividirPor == 0) {
            dividirPor = 1;
        }
        if (multiplicarPor == 0) {
            multiplicarPor = 1;
        }
        if (StringUtil.stringNullOrEmpty((String)(configuracao = serial.getConfiguracaoResumida()))) {
            configuracao = "9600,N,8,1";
        }
        BalancaWrapper balanca = new BalancaWrapper();
        balanca.setMarcaBalanca((MarcaBalanca)EnumUtils.getPorId(MarcaBalanca.class, (Object)marcaBalanca));
        balanca.setModelo((ModeloBalanca)EnumUtils.getPorId(ModeloBalanca.class, (Object)modelo));
        balanca.setPortaSerial(portaSerial);
        balanca.setDividirPor(dividirPor);
        balanca.setMultiplicarPor(multiplicarPor);
        balanca.setConfiguracaoPorta(configuracao);
        balanca.setSerial(JsonUtil.toJson((Object)serial));
        return balanca;
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    public void create(@RequestBody BalancaWrapper balanca) {
        Serial serial = new Serial(balanca.getConfiguracaoPorta());
        UnicoBalancaProperties.getInstance().setInt("Balanca.Modelo", balanca.getModelo().getId().intValue());
        UnicoBalancaProperties.getInstance().setInt("Balanca.Marca", balanca.getMarcaBalanca().getId().intValue());
        UnicoBalancaProperties.getInstance().setString("Balanca.PortaSerial", balanca.getPortaSerial());
        UnicoBalancaProperties.getInstance().setString("Balanca.Baudrate", serial.getVelocidade());
        UnicoBalancaProperties.getInstance().setString("Balanca.Parity", serial.getParidade());
        UnicoBalancaProperties.getInstance().setString("Balanca.Databits", serial.getPalavra());
        UnicoBalancaProperties.getInstance().setString("Balanca.Stopbits", serial.getStopbits());
        UnicoBalancaProperties.getInstance().setInt("Balanca.DividirPor", balanca.getDividirPor());
        UnicoBalancaProperties.getInstance().setInt("Balanca.MultiplicarPor", balanca.getMultiplicarPor());
        UnicoBalancaProperties.getInstance().gravar();
    }
}

