/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.balanca.tara;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.Tara;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.TaraRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/taras"})
@SubMenuMapping(MENU="SubMenuEstoqueAuxiliar", NOME="Taras", ROTA="/estoques/taras", PROGRAMA=1513)
public class TaraCrudController
extends CrudController<Tara, TaraRN> {
    public TaraCrudController() {
        super((AbstractRegraNegocio)TaraRN.getInstance(), Tara::new);
    }

    protected String getCacheId() {
        return "taras";
    }

    protected GridBuilder<TaraRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 80, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("variavel", "Vari\u00e1vel", 150, true));
        colunas.add(new ColunaSQL("minima", "M\u00edmina", 150, true));
        colunas.add(new ColunaSQL("maxima", "M\u00e1xima", 150, true));
        GridBuilder grid = new GridBuilder(TaraRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected void beforeSave(Tara tara, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (tara.getMinima().compareTo(BigDecimal.ZERO) <= 0) {
            String msg = tara.isVariavel() ? "A tara m\u00ednima deve ser maior que zero." : "A tara deve ser maior que zero.";
            throw new UnicoMensagemUsuarioException("EST126", msg);
        }
        if (tara.isVariavel()) {
            if (tara.getMaxima().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UnicoMensagemUsuarioException("EST127", "A tara m\u00e1xima deve ser maior que zero.");
            }
            if (tara.getMaxima().compareTo(tara.getMinima()) <= 0) {
                throw new UnicoMensagemUsuarioException("WPRD448", "A tara m\u00e1xima deve ser maior que a tara m\u00ednima.");
            }
        } else {
            tara.setMaxima(BigDecimal.ZERO);
        }
    }
}

