/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.categoriaecommerce;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.b2c.GrupoShop;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.domain.regranegocio.b2c.GrupoShopRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/categoria-ecommerce"})
@SubMenuMapping(MENU="SubMenuEcommerceGeral", ICONE="icon-grade-produto", NOME="Categorias", ROTA="/produtos-module/categoria-ecommerce", PROGRAMA=1000063)
public class CategoriaEcommerceCrudControler
extends HierarquiaCrudController<GrupoShop, GrupoShopRN> {
    public CategoriaEcommerceCrudControler() {
        super((HierarquiaRN)GrupoShopRN.getInstance(), GrupoShop::new, true);
    }

    protected String getCacheId() {
        return "categoria-ecommerce";
    }

    protected GridBuilder<GrupoShopRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        GridBuilder grid = new GridBuilder(GrupoShopRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        GrupoShop grupoShop = (GrupoShop)GrupoShopRN.getInstance().buscarPorId(id);
        if (!GrupoShopRN.getInstance().isHierarquiaPossuiFilhos(grupoShop.getCodigo()) && ProdutoRN.getInstance().countRegistrosPorIdGrupoShop(id) > 0) {
            throw new UnicoMensagemUsuarioException("WWW673", "N\u00e3o \u00e9 poss\u00edvel inserir uma subcategoria em '" + grupoShop.getNome() + "', pois j\u00e1 existem produtos cadastrados para ele");
        }
        if (grupoShop.isTerceiroNivel()) {
            throw new UnicoMensagemUsuarioException("WWW674", "Permitido somente tr\u00eas n\u00edveis na categoria do e-commerce.");
        }
        return true;
    }
}

