/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.cartacorrecao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.conhecimento.CartaCorrecaoConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cte.regranegocio.CartaCorrecaoConhecimentoTransporteRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/carta-correcao-cte"})
public class CartaCorrecaoCteJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public CartaCorrecaoCteJobController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CartaCorrecaoConhecimentoTransporte cartaCorrecao = (CartaCorrecaoConhecimentoTransporte)CartaCorrecaoConhecimentoTransporteRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (cartaCorrecao == null) {
            throw new UnicoMensagemUsuarioException("WNTF37", "Carta de corre\u00e7\u00e3o n\u00e3o encontrada.");
        }
        ConhecimentoTransporte conhecimentoTransporte = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(cartaCorrecao.getIdConhecimentoTransporte());
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        Malote malote = new Malote();
        List sources = CartaCorrecaoConhecimentoTransporteRN.getInstance().getAnexosEmail(SessaoUtil.getSessao(), conhecimentoTransporte, cartaCorrecao);
        for (DataSource source : sources) {
            if (source instanceof UnicoByteArrayDataSource) {
                try {
                    malote.inclui(source.getName(), Util.inputStream2ByteArray((InputStream)source.getInputStream()));
                    continue;
                }
                catch (IOException e) {
                    throw new UnicoMensagemUsuarioException("WWW569", "Erro ao anexar documento " + source.getName() + ".");
                }
            }
            malote.inclui(source.getName(), Util.inputStream2ByteArray((InputStream)((InputStreamDataSource)source).getInputStream()));
        }
        notificacao.setDataSources(sources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Carta de corre\u00e7\u00e3o de conhecimento de transporte eletr\u00f4nico (CT-e)");
        taskEmail.createTask((Object)parametrosEmail, compartilhamento.getAssunto());
    }
}

