/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.parametroscte;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.common.enums.TipoAmbiente;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.conhecimento.ParametroCTE;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-cte"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Par\u00e2metros do CT-e", ROTA="/conhecimento-transporte-saida/parametros-cte", PROGRAMA=87)
public class ParametroCteCrudController
extends SimpleCrudController<ParametroCTE, FilialRN> {
    private final LicencaService licencaService;

    @Autowired
    public ParametroCteCrudController(LicencaService licencaService) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.Dacte);
        this.licencaService = licencaService;
    }

    @DBAutoCommit
    public ParametroCTE get(Long parentId) {
        ParametroCTE parametro = ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroCTE();
        if (!StringUtil.stringNullOrEmpty((String)parametro.getArquivoImagemDacte())) {
            String url = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Dacte, TipoImagem.Pequena, parametro.getArquivoImagemDacte(), parametro.getImagemDacte());
            parametro.setArquivoImagemDacte(url);
        }
        return parametro;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroCTE entity) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial());
        ParametroCTE parametrosOriginais = filial.getParametroCTE();
        if (parametrosOriginais != null && !StringUtil.stringNullOrEmpty((String)parametrosOriginais.getArquivoImagemDacte())) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Damdfe, TipoImagem.Pequena, parametrosOriginais.getArquivoImagemDacte());
            if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDacte()) || !entity.getArquivoImagemDacte().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Damdfe, parametrosOriginais.getArquivoImagemDacte());
                if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDacte())) {
                    entity.setImagemDacte(null);
                }
            } else {
                entity.setArquivoImagemDacte(parametrosOriginais.getArquivoImagemDacte());
            }
        }
        filial.setParametroCTE(entity);
        if (this.licencaService.getDadosLicenca().isDemonstracao()) {
            filial.getParametroCTE().setTipoAmbienteCte(TipoAmbiente.HOMOLOGACAO);
        }
        FilialRN.getInstance().gravar(1, filial, true, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)entity);
        return filial.getId();
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }
}

