/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.contadorrevenda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ContadorRevenda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.ContadorRevendaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contadores-revendas"})
public class ContadorRevendaCrudController
extends CrudController<ContadorRevenda, ContadorRevendaRN> {
    public ContadorRevendaCrudController() {
        super((AbstractRegraNegocio)ContadorRevendaRN.getInstance(), ContadorRevenda::new);
        this.dependsOn("idRevenda");
    }

    @RequestMapping(value={"/validar-contador"})
    @DBAutoCommit
    public boolean validarContador(@RequestParam Long idRevenda, @RequestParam Long idContador) throws UnicoMensagemUsuarioException {
        ContadorRevenda contador = ContadorRevendaRN.getInstance().buscarContador(idRevenda, idContador);
        if (contador != null) {
            throw new UnicoMensagemUsuarioException("WWW493", "O contador j\u00e1 est\u00e1 relacionado para essa revenda.");
        }
        return true;
    }

    protected String getCacheId() {
        return "contadores-revendas";
    }

    protected GridBuilder<ContadorRevendaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idRevenda", "idRevenda", 0, false));
        colunas.add(new ColunaSQL("idcontador", "idContador", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigo", "C\u00f3digo", 120, true, new String[]{"fk_contadorrevenda_cont"}));
        colunas.add(new ColunaSQL("nome", "nome", "Nome", 0, true, new String[]{"fk_contadorrevenda_cont"}));
        colunas.add(new ColunaSQL("cnpjCpf", "cnpjCpf", "CNPJ/CPF", 100, true, new String[]{"fk_contadorrevenda_cont"}));
        colunas.add(new ColunaSQL("nome", "nomeEstado", "Estado", 150, true, new String[]{"fk_contadorrevenda_cont", "fk_entidade_estado"}));
        colunas.add(new ColunaSQL("nome", "nomeCidade", "Cidade", 150, true, new String[]{"fk_contadorrevenda_cont", "fk_entidade_cidade"}));
        colunas.add(new ColunaSQL("telefone", "telefone", "Telefone", 100, true, new String[]{"fk_contadorrevenda_cont"}));
        return new GridBuilder(ContadorRevendaRN.getInstance().getTabela(), colunas);
    }
}

