/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.exportarxml;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ArquivoExportacaoXML;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ExportacaoXMLFiltro;
import br.intelidata.commons.modulo.exportacaoxml.regranegocio.ExportacaoXMLNovaRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExportarXml
extends AbstractPrepareJob {
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");
    private final Logger log = LoggerFactory.getLogger(JobExportarXml.class);

    public JobExportarXml(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public boolean isGzip() {
        return false;
    }

    public void execute() throws Exception {
        ExportacaoXMLFiltro filtroExportacao = (ExportacaoXMLFiltro)this.getObjetoDeserializado(ExportacaoXMLFiltro.class);
        ExportacaoXMLNovaRN exportacao = new ExportacaoXMLNovaRN(SessaoUtil.getSessaoJob(), filtroExportacao);
        if (exportacao.getArquivos().isEmpty() || exportacao.getRelatorios().isEmpty()) {
            throw new UnicoMensagemUsuarioException("WWW556", "Nenhum documento foi encontrado!");
        }
        if (filtroExportacao.isGravarEmDiretorio()) {
            List arquivos = exportacao.getArquivos().values().stream().map(ArquivoExportacaoXML::getFile).collect(Collectors.toList());
            arquivos.addAll(exportacao.getRelatorios());
            File file = this.montaZipFile(arquivos);
            this.saveFile(file);
        } else {
            StringBuilder sbNomeCnpj = new StringBuilder();
            for (Long idFilial : filtroExportacao.getIdFiliais()) {
                Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
                if (filial == null) continue;
                String nomeCnpj = "- " + filial.getNome() + " - " + filial.getCnpj();
                if (sbNomeCnpj.length() > 0) {
                    sbNomeCnpj.append(Util.lineSeparator).append(nomeCnpj);
                    continue;
                }
                sbNomeCnpj.append(nomeCnpj);
            }
            String assunto = "Arquivos XML do per\u00edodo " + Util.formataDataHora((Temporal)filtroExportacao.getDataInicial(), (String)"dd/MM/yyyy") + " at\u00e9 " + Util.formataDataHora((Temporal)filtroExportacao.getDataFinal(), (String)"dd/MM/yyyy");
            String descricao = "Segue em anexo arquivos XML referentes aos documentos fiscais do per\u00edodo " + Util.formataDataHora((Temporal)filtroExportacao.getDataInicial(), (String)"dd/MM/yyyy") + " at\u00e9 " + Util.formataDataHora((Temporal)filtroExportacao.getDataFinal(), (String)"dd/MM/yyyy") + "." + Util.lineSeparator + Util.lineSeparator;
            descricao = descricao + (filtroExportacao.getIdFiliais().size() > 1 ? "<B>Contribuintes:</B> " : "<B>Contribuinte:</B> ") + Util.lineSeparator + sbNomeCnpj;
            FileDataSource[] dataSource = (FileDataSource[])Stream.concat(exportacao.getArquivos().values().stream().map(ArquivoExportacaoXML::getFile).map(FileDataSource::new), exportacao.getRelatorios().stream().map(FileDataSource::new)).toArray(FileDataSource[]::new);
            ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessaoJob(), (String)filtroExportacao.getEmail(), null, (String)assunto, (String)descricao);
            parametrosEmailWeb.setAnexos((DataSource[])dataSource);
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Exporta\u00e7\u00e3o de documentos fiscais para a contabilidade");
            taskEmail.createTask((Object)parametrosEmailWeb, this.getTask().getUuid(), parametrosEmailWeb.getAssunto(), false);
        }
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Exporta\u00e7\u00e3o de documentos fiscais para a contabilidade realizada com sucesso.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falha ao exportar documentos fiscais para a contabilidade.");
    }

    private File montaZipFile(List<File> arquivos) throws UnicoMensagemUsuarioException {
        try {
            File scratchFile = File.createTempFile("XMLS", ".zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (File file : arquivos) {
                    String nomeArquivo = file.getName();
                    if (FilenameUtils.getExtension((String)nomeArquivo).equalsIgnoreCase("pdf")) {
                        nomeArquivo = "exportacao" + System.currentTimeMillis() + ".pdf";
                    } else if (nomeArquivo.contains("-temp")) {
                        nomeArquivo = nomeArquivo.substring(0, nomeArquivo.indexOf("-temp")) + ".zip";
                    }
                    FileUtil.comprimirArquivoEmDisco((ZipOutputStream)zipOut, (File)file, (String)nomeArquivo);
                    if (file.delete()) continue;
                    this.log.error("N\u00e3o foi poss\u00edvel excluir o arquivo tempor\u00e1rio de exporta\u00e7\u00e3o de XMLs. Arquivo: " + file.getName());
                }
            }
            return scratchFile;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW427", e.getMessage());
        }
    }
}

