/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.fechamentopdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusFechamentoPdv;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.domain.regranegocio.OperacaoCommonRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.fechamentopdv.TransferenciaFechamentoWrapper;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/operacao-fechamento-pdv"})
public class OperacaoFechamentoCrudController
extends CrudController<Operacao, OperacaoCommonRN> {
    public OperacaoFechamentoCrudController() {
        super((AbstractRegraNegocio)OperacaoCommonRN.getInstance(), Operacao::new, true, false);
    }

    protected String getCacheId() {
        return "operacao-fechamento-pdv";
    }

    protected GridBuilder<?> getGridBuilder() {
        USelect subQuery = new USelect("pagamento", "pag");
        subQuery.add(new ColunaSQL("finalizador"));
        subQuery.add((ColunaSQL)new Referencia("idoperacao"));
        subQuery.add(new Condicao("idoperacao", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("horainicial"));
        colunas.add(new ColunaSQL(new Coalesce("fechamentolocal", "0"), "fechamentolocal", new String[0]));
        colunas.add(new ColunaSQL(new Coalesce("statusnfce", "0"), "statusnfce", new String[0]));
        colunas.add(new ColunaSQL("filial", "Filial", 180, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 180, true));
        colunas.add(new ColunaSQL("usuario", "Usu\u00e1rio", 180, true));
        colunas.add(new ColunaSQL("data", "Data", 200, true));
        colunas.add(new ColunaSQL("pdv", "Pdv", 180, true));
        colunas.add(new ColunaSQL("numeronfce", "N\u00famero", 180, true));
        colunas.add(new ColunaSQL("valorLiquido", "Valor", 180, true));
        colunas.add(new ColunaSQL("cancelado", "Cancelado", 180, true));
        GridBuilder controller = new GridBuilder(((OperacaoCommonRN)this.rn).getTabela(), colunas, "fechamentoPdvOperacao");
        controller.addReferencia(new Referencia("idFechamento"));
        controller.addReferencia(new Referencia(subQuery, "finalizador"));
        controller.addCondicao(new Condicao("statusnfce", Operador.DIFERENTE, StatusNfce.REJEITADA.getId().intValue()));
        controller.addCondicao(new Condicao("fechamentolocal", Operador.IGUAL, 0));
        controller.addOrdem(new Ordem("horainicial", true));
        controller.addOrdem(new Ordem("id", true));
        return controller;
    }

    @RequestMapping(value={"/nfce"})
    @DBAutoCommit
    public boolean isNfce(@RequestParam Long idOperacao) {
        Operacao operacao = (Operacao)OperacaoCommonRN.getInstance().buscarPorId(idOperacao);
        if (operacao != null) {
            return operacao.isNfce();
        }
        return false;
    }

    @RequestMapping(value={"/transferir"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarTransferencia(@RequestBody TransferenciaFechamentoWrapper transferencia) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoDestino;
        FechamentoPdv fechamentoOrigem = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(transferencia.getIdFechamentoOrigem());
        if (transferencia.isCriarNovo()) {
            fechamentoDestino = new FechamentoPdv();
            fechamentoDestino.setData(transferencia.getDataNovoFechamento());
            fechamentoDestino.setStatus(StatusFechamentoPdv.PENDENTE_FECHAMENTO);
            fechamentoDestino.setIdUsuario(fechamentoOrigem.getIdUsuario());
            fechamentoDestino.setPdv(fechamentoOrigem.getPdv());
            fechamentoDestino.setIdFilial(fechamentoOrigem.getIdFilial());
        } else {
            fechamentoDestino = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(transferencia.getIdFechamentoDestino());
            if (fechamentoOrigem.equals((Object)fechamentoDestino)) {
                throw new UnicoMensagemUsuarioException("WPDV1028", "Fechamento de Destino deve ser diferente do fechamento de origem");
            }
            if (!fechamentoOrigem.getUsuarioCaixa().equals((Object)fechamentoDestino.getUsuarioCaixa())) {
                throw new UnicoMensagemUsuarioException("WPDV1041", "Usu\u00e1rio do Fechamento de Origem \u00e9 diferente do Usu\u00e1rio do Fechamento de Destino");
            }
            if (fechamentoDestino.getStatus() == StatusFechamentoPdv.FECHADO) {
                throw new UnicoMensagemUsuarioException("WPDV1042", "Fechamento de Destino est\u00e1 fechado");
            }
        }
        FechamentoPdvCommonRN.getInstance().transferirOperacoes(SessaoUtil.getSessao(), fechamentoOrigem, fechamentoDestino, transferencia.getIds());
    }
}

