/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.adicional.CobrancaEmailWeb;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoGeracaoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoIdentificacaoBeneficiarioClienteUBoleto;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoSaidaBoleto;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.wrapper.GeracaoRemessaWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetorno;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteAcaoCobrancaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.WhatsAppService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa.GeracaoRemessaJobSimpleController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa.GeracaoRetornoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa.IGeraRemessa;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/gerar-remessas"})
public class GeracaoRemessaJobSimpleController
implements IGeraRemessa {
    private final TaskManager taskManager;
    private final WhatsAppService whatsAppService;

    @Autowired
    public GeracaoRemessaJobSimpleController(TaskManager taskManager, WhatsAppService whatsAppService) {
        this.taskManager = taskManager;
        this.whatsAppService = whatsAppService;
    }

    @RequestMapping(value={"/compartilhar"}, method={RequestMethod.POST})
    @DBTransaction
    public GeracaoRetornoWrapper compartilharBoletos(@RequestBody GeracaoRemessaWrapper remessaWrapper) throws UnicoMensagemUsuarioException {
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        this.validarRemessa(remessaWrapper, contaCorrente, false);
        if (!ContaCorrenteRN.getInstance().isContaCorrenteImprimeBoleto(remessaWrapper.getIdContaCorrenteRemessa())) {
            throw new UnicoMensagemUsuarioException("WWW666", "Esta conta corrente n\u00e3o emite boletos.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        Long idEntidade = ((DocumentoCobranca)remessaWrapper.getDocumentos().get(0)).getIdEntidade();
        boolean isEmail = remessaWrapper.getTipoSaidaBoleto() == TipoSaidaBoleto.EMAIL || remessaWrapper.getTipoSaidaBoleto() == TipoSaidaBoleto.EMAIL_COM_NOTA_FISCAL;
        List idsDocumentos = remessaWrapper.getDocumentos().stream().map(DocumentoCobranca::getIdFinanceiroDado).collect(Collectors.toList());
        FinanceiroDadoRN.getInstance().verificaDocumentosPendentes(idsDocumentos);
        if (!isEmail && remessaWrapper.getDocumentos().stream().anyMatch(d -> !d.getIdEntidade().equals(idEntidade))) {
            throw new UnicoMensagemUsuarioException("WWW570", "Para envio de notifica\u00e7\u00e3o via WhatsApp, selecione apenas documentos do mesmo cliente!");
        }
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        boolean isAsaas = BancoDisponivel.isAsaas((String)banco.getCodigo());
        boolean possuiIntegracao = ContaCorrenteRN.getInstance().possuiIntegracaoOnline(contaCorrente);
        if (!isEmail) {
            ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper, isAsaas);
            ContaCorrenteAcaoCobranca contaAcao = (ContaCorrenteAcaoCobranca)ContaCorrenteAcaoCobrancaRN.getInstance().buscarPorId(remessaWrapper.getIdAcaoCobrancaRemessa());
            ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
            contaAcaoRemessa.setAcaoCobranca(contaAcao);
            BancoOnlineRetorno retorno = null;
            if (possuiIntegracao) {
                retorno = this.remessaOline(remessaWrapper, false, null).getBancoOnlineRetorno();
            }
            NotificacaoCompartilhamento notificacao = remessaWrapper.getNotificacao();
            CobrancaEmailWeb cobranca = CobrancaEscrituralRN.getInstance().gerarBoletoWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, remessaWrapper.getTipoSaidaBoleto(), contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao(), notificacao.getTipo(), possuiIntegracao);
            PropriedadeRN.getInstance().setPropriedade(sessao, 592, remessaWrapper.getPercentualDescontoPagamentoAteVencimento().toString());
            String nomeEmpresa = TipoIdentificacaoBeneficiarioClienteUBoleto.NOME.equals((Object)contaCorrente.getTipoIdentificacaoBeneficiario()) ? sessao.getFilial().getNome() : sessao.getFilial().getRazaoSocialCompleta();
            List notificacoes = new ArrayList();
            if (ListMapUtil.listNullOrEmpty(notificacoes)) {
                notificacoes = CobrancaEscrituralRN.getInstance().geraNotificacaoDocumentosWeb(sessao, cobranca.getMapPdf(), retorno, notificacao);
            }
            String msgWhats = this.whatsAppService.enviarWhatsApp(notificacoes, sessao);
            return new GeracaoRetornoWrapper(msgWhats, ((Notificacao)notificacoes.get(0)).getFone(), remessaWrapper.getDocumentos());
        }
        FinanceiroDadoRN.getInstance().atualizarStatusJobFinanceiroWeb(idsDocumentos, StatusJobItem.PENDENTE);
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        task.createTask((Object)remessaWrapper);
        return null;
    }

    @RequestMapping(value={"/atualizar-documentos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<DocumentoCobranca> atualizar(@RequestBody List<DocumentoCobranca> documentos) {
        return FinanceiroDadoRN.getInstance().atualizaDocumentosCobranca(documentos);
    }

    static /* synthetic */ TaskManager access$000(GeracaoRemessaJobSimpleController x0) {
        return x0.taskManager;
    }
}

