/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.grupo;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoAliquotaEstado;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TributacaoProduto;
import br.intelidata.commons.domain.regranegocio.AliquotaEstadoCommonRN;
import br.intelidata.commons.domain.regranegocio.GrupoProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.domain.regranegocio.MotivoDesoneracaoIcmsPafRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupos-produto"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarProdutos", NOME="Grupos de produto", ICONE="icon-incluir-subgrupo", ROTA="/produtos-module/grupos-produto", PROGRAMA=9)
public class GrupoProdutoCrudController
extends HierarquiaCrudController<HierarquiaGrupoProduto, HierarquiaGrupoProdutoRN> {
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public GrupoProdutoCrudController(FuncionalidadeService funcionalidadeService) {
        super((HierarquiaRN)HierarquiaGrupoProdutoRN.getInstance(), HierarquiaGrupoProduto::new, true);
        this.funcionalidadeService = funcionalidadeService;
    }

    @DBAutoCommit
    public Hierarquia getNome(@PathVariable Long id) {
        return HierarquiaGrupoProdutoRN.getInstance().buscarDadosTreeWeb(id);
    }

    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        HierarquiaGrupoProduto hierarquia = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(id);
        if (!HierarquiaGrupoProdutoRN.getInstance().isHierarquiaPossuiFilhos(hierarquia.getCodigo()) && ProdutoRN.getInstance().countRegistrosPorIdHierarquia(hierarquia.getId()) > 0) {
            throw new UnicoMensagemUsuarioException("WPRD108", "N\u00e3o \u00e9 poss\u00edvel inserir um subgrupo em '" + hierarquia.getNome() + "', pois j\u00e1 existem produtos cadastrados para ele");
        }
        return super.validateSubgroup(id);
    }

    protected void beforeRead(HierarquiaGrupoProduto hierarquiaGrupoProduto, int modo, Optional<Long> parentId) {
        if (!StringUtil.stringNullOrEmpty((String)hierarquiaGrupoProduto.getTributacao())) {
            TributacaoProduto tributacaoProduto = (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)hierarquiaGrupoProduto.getTributacao());
            if (tributacaoProduto != null) {
                hierarquiaGrupoProduto.setTributacao(tributacaoProduto.name());
            }
        } else {
            hierarquiaGrupoProduto.setTributacao(TributacaoProduto.TRIBUTADO.name());
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            hierarquiaGrupoProduto.setPautasPreco(GrupoProdutoPautaPrecoRN.getInstance().buscarListaPorIdGrupoProduto(hierarquiaGrupoProduto.getId()));
        }
    }

    protected void beforeSave(HierarquiaGrupoProduto hierarquiaGrupoProduto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (hierarquiaGrupoProduto.getTributacao().equals(TributacaoProduto.TRIBUTADO.getId())) {
            if (hierarquiaGrupoProduto.getAliquotaIcmsInterna() != null && hierarquiaGrupoProduto.getAliquotaIcmsInterna().compareTo(BigDecimal.ZERO) == 0 && !CstICMS.OUTROS.equals((Object)hierarquiaGrupoProduto.getTributacaoEspecialNfceSat()) && !LicencaManager.getInstance().isNfce(SessaoUtil.getSessao().getFilial())) {
                throw new UnicoMensagemUsuarioException("WPRD199", "Se o campo 'PAF-ECF' for 'Tributado', o campo '% ICMS' deve ser maior que zero");
            }
            boolean aliquotaValida = AliquotaEstadoCommonRN.getInstance().isAliquotaValida(TipoAliquotaEstado.ICMS, SessaoUtil.getSessao().getFilial().getIdEstado(), hierarquiaGrupoProduto.getAliquotaIcmsInterna());
            if (!aliquotaValida) {
                throw new UnicoMensagemUsuarioException("WPRD200", "Al\u00edquota de ICMS informada \u00e9 inv\u00e1lida. Por favor verifique o cadastro de Al\u00edquotas por estado.");
            }
        }
        MotivoDesoneracaoIcmsPafRN.getInstance().validarMotivoDesoneracaoIcms(hierarquiaGrupoProduto.getTributacaoEspecialNfceSat(), (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)hierarquiaGrupoProduto.getTributacao()), hierarquiaGrupoProduto.getMotivoDesoneracaoIcms());
    }

    protected GridBuilder<HierarquiaGrupoProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 450, true));
        colunas.add(new ColunaSQL("comissao", "comissao", "% comiss\u00e3o", 150, true, new String[0]));
        colunas.add(new ColunaSQL("comissaoavista", "comissaoAVista", "% comiss\u00e3o \u00e0 vista", 150, true, new String[0]));
        colunas.add(new ColunaSQL("comissaoaprazo", "comissaoAPrazo", "% comiss\u00e3o a prazo", 150, true, new String[0]));
        colunas.add(new ColunaSQL("comissaoquitacao", "comissaoQuitacao", "% comiss\u00e3o na quita\u00e7\u00e3o", 150, true, new String[0]));
        colunas.add(new ColunaSQL("csticms", "cstICMS", "Situa\u00e7\u00e3o tribut\u00e1ria", 0, true, new String[0]));
        if (SessaoUtil.getSessao().getFilial().getTipoEnquadramento() == TipoEnquadramentoFilial.SIMPLESNACIONAL) {
            colunas.add(new ColunaSQL("cstsnicms", "cstSNICMS", "ST Simples Nacional", 0, true, new String[0]));
        }
        this.addColunaNivel(colunas);
        colunas.forEach(colunaSQL -> {
            Coluna coluna = HierarquiaGrupoProdutoRN.getInstance().buscarColuna(HierarquiaGrupoProdutoRN.getInstance().getTabela(), colunaSQL.getNome());
            if (coluna != null) {
                colunaSQL.setClasseValor(coluna.getClasseDado());
            }
        });
        GridBuilder grid = new GridBuilder(HierarquiaGrupoProdutoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected String getCacheId() {
        return "grupos-produto";
    }
}

