/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.imagempdv;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ImagemPDV;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.modulo.pdv.regranegocio.ImagemPDVRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.imagempdv.ImagensPdv;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/imagens-pdv"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Imagens promocionais", ROTA="/pdvs/imagens-pdv", PROGRAMA=76)
public class ImagemPDVCrudController
extends SimpleCrudController<ImagensPdv, ImagemPDVRN> {
    @DBAutoCommit
    public ImagensPdv get(Long parentId) {
        ImagensPdv imagens = new ImagensPdv();
        List imagemPDV = ImagemPDVRN.getInstance().buscaListaPorFilial(SessaoUtil.getSessao().getIdFilial());
        imagemPDV.forEach(osImagem -> osImagem.setCaminhoOriginal(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ImagemPDV, TipoImagem.TamanhoOriginal, osImagem.getCaminhoOriginal())));
        imagens.setImagens(imagemPDV);
        return imagens;
    }

    public void loadFile(MultipartFile[] files, ImagensPdv imagensPDV) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            Map<Object, Object> mapImagens = !ListMapUtil.listNullOrEmpty((List)imagensPDV.getImagens()) ? imagensPDV.getImagens().stream().collect(Collectors.groupingBy(ImagemPDV::getNome)) : new HashMap();
            BigDecimal tamanhoPreferencia = new BigDecimal(PropriedadeRN.getInstance().getPropriedadeInt(Contexto.getInstance().getFilial(), 409));
            for (MultipartFile file : files) {
                Object[] split;
                String originalName = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)originalName) || ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) continue;
                try {
                    List imagemPDV;
                    Object fieldName = split[0];
                    if (!((String)fieldName).equalsIgnoreCase("img") || ListMapUtil.listNullOrEmpty((List)(imagemPDV = (List)mapImagens.get(split[1])))) continue;
                    byte[] imagem = file.getBytes();
                    BigDecimal tamanhoArquivo = new BigDecimal(file.getSize()).divide(Util.MIL_VINTE_QUATRO, 6).setScale(0, 1);
                    if (tamanhoArquivo.compareTo(new BigDecimal(20480)) > 0) {
                        throw new UnicoMensagemUsuarioException("WPDV1496", "O tamanho da imagem '" + (String)split[1] + "' n\u00e3o pode ser superior a 20480 KB.");
                    }
                    if (tamanhoArquivo.compareTo(tamanhoPreferencia) > 0) {
                        String mensagemErro = String.format("O tamanho da imagem '%s' ultrapassa o limite de %s KB configurado nas prefer\u00eancias do sistema.", split[1], tamanhoPreferencia);
                        throw new UnicoMensagemUsuarioException("WPDV1192", mensagemErro);
                    }
                    String caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ImagemPDV, file);
                    imagemPDV.forEach(i -> {
                        i.setCaminhoOriginal(caminho);
                        if (this.saveFile.isTabela()) {
                            i.setImagem(imagem);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UnicoMensagemUsuarioException("WWW351", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
                }
            }
        }
    }

    @DBTransaction
    public Long create(@RequestBody ImagensPdv imagensPdv) throws UnicoMensagemUsuarioException {
        List listaIdImagens = imagensPdv.getImagens().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId()) && i.getId() > 0L).map(ImagemPDV::getId).collect(Collectors.toList());
        List imgPDV = ImagemPDVRN.getInstance().buscaListaPorFilial(SessaoUtil.getSessao().getIdFilial());
        for (ImagemPDV imagem : imgPDV) {
            if (listaIdImagens.contains(imagem.getId())) continue;
            ImagemPDVRN.getInstance().excluir((AbstractPojo)imagem, SessaoUtil.getSessao());
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ImagemPDV, imagem.getCaminhoOriginal());
        }
        for (ImagemPDV imagemPDV : imagensPdv.getImagens()) {
            if (imagemPDV.isUtilizarTodasFiliais()) {
                imagemPDV.setIdFilial(Long.valueOf(0L));
            } else {
                imagemPDV.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
            }
            if (NumberUtil.longNullOuZero((Long)imagemPDV.getId())) {
                ImagemPDVRN.getInstance().incluir((AbstractPojo)imagemPDV, SessaoUtil.getSessao());
                continue;
            }
            if (imagemPDV.getCaminhoOriginal() != null) {
                imagemPDV.setCaminhoOriginal(imagemPDV.getCaminhoOriginal().replace(this.saveFile.getServidorURL(), ""));
            }
            ImagemPDVRN.getInstance().alterar((AbstractPojo)imagemPDV, SessaoUtil.getSessao());
        }
        return 0L;
    }
}

