/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importardepedidocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.pojo.enuns.StatusPedidoCompra;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.PedidoCompraWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/importar-pedidos-compras"})
public class ImportarPedidoCompraCrudController {
    @RequestMapping(value={"importar"})
    @DBAutoCommit
    public PedidoCompraWrapper importarNotaDePedidoCompra(@RequestBody PedidoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        PedidoCompra pedidoCompra = PedidoCompraRN.getInstance().buscarPorCodigoIdFIlial(wrapper.getCodigo(), SessaoUtil.getSessao().getIdFilial());
        if (pedidoCompra != null) {
            if (pedidoCompra.getStatus().equals((Object)StatusPedidoCompra.FECHADO)) {
                throw new UnicoMensagemUsuarioException("WNTF381", "Pedido de compra j\u00e1 foi fechado.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WNTF382", "Pedido de compra n\u00e3o existe.");
        }
        List<Long> ids = Collections.singletonList(pedidoCompra.getId());
        String msgUsuario = PedidoCompraRN.getInstance().validaPedidosParaFaturar(ids);
        wrapper.setMsgUsuario(msgUsuario);
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().importarPedidosCompra(SessaoUtil.getSessao(), ids, new HashMap(), wrapper.getIdOperacaoFiscal());
        notaFiscal.setGeraNovoPedidoSaldo(wrapper.isGeraNovoPedidoSaldo());
        for (int i = 0; i < notaFiscal.getNotaFiscalItens().size(); ++i) {
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setId(Long.valueOf(Long.parseLong(String.valueOf(-(i + 1)))));
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setItemPermiteDesconto(true);
        }
        Filial filialNotaFiscal = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        wrapper.setNotaFiscal(notaFiscal);
        wrapper.setCriticas(NotaFiscalItemRN.getInstance().gerarCriticasFaturamentoWeb(filialNotaFiscal, notaFiscal.getNotaFiscalItens(), false));
        return wrapper;
    }
}

