/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.ordemservicoevento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.OrdemServicoEvento;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoOrdemServicoEventoEnum;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoEventoRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ordem-servico-evento"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarOrdemServico", NOME="Eventos", ROTA="/ordens-servicos/ordem-servico/:idOrdemServico/ordem-servico-evento", PROGRAMA=612, CUSTOM_ACTION=true)
public class OrdemServicoEventoCrudController
extends CrudController<OrdemServicoEvento, OrdemServicoEventoRN> {
    public OrdemServicoEventoCrudController() {
        super((AbstractRegraNegocio)OrdemServicoEventoRN.getInstance(), OrdemServicoEvento::new);
        this.dependsOn("idOrdemServico");
    }

    protected String getCacheId() {
        return "ordem-servico-evento";
    }

    protected GridBuilder<OrdemServicoEventoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idOrdemServico", "idOrdemServico", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 150, true));
        colunas.add(new ColunaSQL("nome", "idTecnicoDe", "T\u00e9cnico original", 300, true, new String[]{"fk_ordemservicoevento_entde"}));
        colunas.add(new ColunaSQL("nome", "idTecnicoPara", "T\u00e9cnico encaminhado", 300, true, new String[]{"fk_ordemservicoevento_entpara"}));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 420, true));
        ColunaSQL colunaEvento = new ColunaSQL("descricao", "tipo", new String[]{"fk_ordemservicoevento_tipo"});
        colunaEvento.setDescricao("Tipo");
        colunaEvento.setTamanho(150);
        colunaEvento.setVisivel(true);
        colunas.add(colunaEvento);
        ColunaSQL corColuna = new ColunaSQL("cor", "corTipo", new String[]{"fk_ordemservicoevento_tipo"});
        corColuna.setDescricao("Cor");
        corColuna.setTamanho(0);
        corColuna.setVisivel(false);
        colunas.add(corColuna);
        GridBuilder gridBuilder = new GridBuilder(OrdemServicoEventoRN.getInstance().getTabela(), colunas);
        gridBuilder.setOrdemDefault(new Ordem("data"));
        return gridBuilder;
    }

    protected void afterCreate(OrdemServicoEvento ordemServicoEvento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.atualizarStatusOS(ordemServicoEvento);
    }

    protected void afterUpdate(OrdemServicoEvento ordemServicoEvento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.atualizarStatusOS(ordemServicoEvento);
    }

    private void atualizarStatusOS(OrdemServicoEvento evento) throws UnicoMensagemUsuarioException {
        TipoOrdemServicoEventoEnum tipo;
        if (!NumberUtil.longNullOuZero((Long)evento.getIdTipoEvento()) && TipoOrdemServicoEventoEnum.PAUSA.equals((Object)(tipo = (TipoOrdemServicoEventoEnum)EnumUtils.getPorId(TipoOrdemServicoEventoEnum.class, (Object)evento.getIdTipoEvento().intValue())))) {
            OrdemServicoRN.getInstance().pausarOrdemServico(SessaoUtil.getSessao(), evento.getIdOrdemServico());
        }
    }
}

