/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfe;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ParametroNFE;
import br.intelidata.commons.domain.pojo.enuns.TipoAmbienteNfe;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-nfe"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Par\u00e2metros da NF-e", ROTA="/notas-fiscais/parametros-nfe", PROGRAMA=30)
public class ParametroNfeCrudController
extends SimpleCrudController<ParametroNFE, FilialRN> {
    private final LicencaService licencaService;

    public ParametroNfeCrudController(LicencaService licencaService) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.Danfe);
        this.licencaService = licencaService;
    }

    @DBAutoCommit
    public ParametroNFE get(Long parentId) {
        ParametroNFE parametro = ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroNFE();
        if (!StringUtil.stringNullOrEmpty((String)parametro.getArquivoImagemDanfe())) {
            String url = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, TipoImagem.Pequena, parametro.getArquivoImagemDanfe(), parametro.getImagemNfe());
            parametro.setArquivoImagemDanfe(url);
        }
        return parametro;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroNFE entity) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial());
        ParametroNFE parametrosOriginais = filial.getParametroNFE();
        if (parametrosOriginais != null) {
            entity.setCertificadoNfe(parametrosOriginais.getCertificadoNfe());
            if (!StringUtil.stringNullOrEmpty((String)parametrosOriginais.getArquivoImagemDanfe())) {
                String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, TipoImagem.Pequena, parametrosOriginais.getArquivoImagemDanfe());
                if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDanfe()) || !entity.getArquivoImagemDanfe().equals(arquivoRelativo)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, parametrosOriginais.getArquivoImagemDanfe());
                    if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDanfe())) {
                        entity.setImagemNfe(null);
                    }
                } else {
                    entity.setArquivoImagemDanfe(parametrosOriginais.getArquivoImagemDanfe());
                }
            }
        }
        filial.setParametroNFE(entity);
        filial.getContador().setEmail(entity.getEmailContador());
        if (this.licencaService.getDadosLicenca().isDemonstracao()) {
            filial.getParametroNFE().setTipoAmbienteNfe(TipoAmbienteNfe.HOMOLOGACAO);
        }
        filial.setNaoGravarListas(true);
        FilialRN.getInstance().gravar(1, filial, true, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)entity);
        return filial.getId();
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }
}

