/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoArquivoBlocoX;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PendenciaSistemaImprimeListaWeb {
    private static UViewer rel;

    public Remessa imprimirAdvertencias(Object[] parametros, String titulo) throws UnicoMensagemUsuarioException {
        List advertenciasLista = null;
        Map advertenciasMap = null;
        for (Object parametro : parametros) {
            block7: {
                try {
                    if (parametro instanceof List) {
                        List listObj = (List)parametro;
                        if (!Util.listNullOrEmpty((List)listObj) && listObj.get(0) instanceof String) {
                            advertenciasLista = listObj;
                        }
                        break block7;
                    }
                    if (!(parametro instanceof Map)) break block7;
                    for (Object e : ((Map)parametro).entrySet()) {
                        Map.Entry ent = (Map.Entry)e;
                        if (!(ent.getKey() instanceof String) || !(ent.getValue() instanceof List)) continue;
                        advertenciasMap = (Map)parametro;
                        break;
                    }
                }
                catch (Throwable e) {
                    return null;
                }
            }
            if (!Util.listNullOrEmpty(advertenciasLista)) {
                return this.imprimir(advertenciasLista, titulo);
            }
            if (Util.mapNullOrEmpty(advertenciasMap)) continue;
            return this.imprimir(advertenciasMap, titulo);
        }
        return null;
    }

    public Remessa acaoBlocoXCadastrosInconsistentes(Object[] parametros) throws UnicoMensagemUsuarioException {
        List advertencias = null;
        TipoArquivoBlocoX tipoArquivo = null;
        for (Object parametro : parametros) {
            if (parametro instanceof List && !Util.listNullOrEmpty((List)((List)parametro)) && ((List)parametro).get(0) instanceof String) {
                advertencias = Stream.of(parametro).map(Object::toString).collect(Collectors.toList());
                continue;
            }
            if (!(parametro instanceof String)) continue;
            tipoArquivo = (TipoArquivoBlocoX)EnumUtils.getPorNomeConstante(TipoArquivoBlocoX.class, (String)parametro.toString());
        }
        if (!Util.listNullOrEmpty(advertencias) && tipoArquivo != null) {
            String titulo = "Relat\u00f3rio de Cr\u00edticas Bloco X - " + tipoArquivo.getDescricao();
            return this.imprimir(advertencias, titulo);
        }
        return null;
    }

    private Remessa imprimir(List<String> advertencias, String titulo) throws UnicoMensagemUsuarioException {
        this.inicializaRelatorio(titulo);
        this.escreve("Advert\u00eancias", advertencias);
        this.finalizaRelatorio();
        return rel.getRemessa();
    }

    private Remessa imprimir(Map<String, List<String>> advertencias, String titulo) throws UnicoMensagemUsuarioException {
        this.inicializaRelatorio(titulo);
        for (Map.Entry<String, List<String>> entry : advertencias.entrySet()) {
            this.escreve(entry.getKey(), entry.getValue());
        }
        this.finalizaRelatorio();
        return rel.getRemessa();
    }

    private void inicializaRelatorio(String titulo) throws UnicoMensagemUsuarioException {
        rel = new UViewer(SaidaRelatorio.PDF, titulo, new int[]{100});
        rel.inicioRelatorio();
    }

    private void escreve(String grupo, List<String> advertencias) {
        rel.escreveTexto(grupo);
        for (String linha : advertencias) {
            rel.inicioLinha();
            rel.escreveColuna(linha);
            rel.fimLinha();
        }
    }

    private void finalizaRelatorio() throws UnicoMensagemUsuarioException {
        rel.saltaLinha();
        rel.saltaLinha();
        rel.fimRelatorio();
    }
}

