/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.filtrosgrid;

import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.enuns.estoque.LimiteEstoqueEnum;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.util.List;

public class FiltroGridLimiteEstoque
implements CustomFilterGrid {
    public void addFilter(Grid<?> grid, List<FilterField> filters) {
        FilterField filtro = this.getFiltro("limiteEstoque", filters);
        if (filtro != null && !StringUtil.stringNullOrEmpty((String)filtro.getValue1())) {
            int estoquePorFilial = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.ESTOQUE_PRODUTO_FILIAL) ? 1 : 0;
            Long idLocalEstoque = null;
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
                idLocalEstoque = Contexto.getInstance().getUsuario().getIdLocalEstoqueTrabalho();
            }
            if (LimiteEstoqueEnum.ABAIXO_MINIMO.name().equalsIgnoreCase(filtro.getValue1())) {
                grid.getGridBuilder().addReferencia(new Referencia(Funcao.BUSCA_ESTOQUE_ABAIXO_MINIMO, "abaixoMinimo", "abaixoMinimo", new Object[]{"t1.id", idLocalEstoque, Contexto.getInstance().getFilial().getId(), estoquePorFilial}));
                grid.getGridBuilder().addCondicao(new Condicao("abaixoMinimo", Operador.MAIOR_QUE, "0"));
            } else if (LimiteEstoqueEnum.ACIMA_MAXIMO.name().equalsIgnoreCase(filtro.getValue1())) {
                grid.getGridBuilder().addReferencia(new Referencia(Funcao.BUSCA_ESTOQUE_ACIMA_MAXIMO, "acimaMaximo", "acimaMaximo", new Object[]{"t1.id", idLocalEstoque, Contexto.getInstance().getFilial().getId(), estoquePorFilial}));
                grid.getGridBuilder().addCondicao(new Condicao("acimaMaximo", Operador.MAIOR_QUE, "0"));
            }
            this.removeFiltro("limiteEstoque", filters);
        }
    }
}

