/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.fornecedor;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoFornecedor;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoFornecedorRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoReturnWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes-fornecedor"})
public class PromocaoFornecedorCrudController
extends CrudController<PromocaoFornecedor, PromocaoFornecedorRN> {
    @Autowired
    public PromocaoFornecedorCrudController() {
        super((AbstractRegraNegocio)PromocaoFornecedorRN.getInstance(), PromocaoFornecedor::new);
        this.dependsOn("idPromocao");
    }

    @RequestMapping(value={"/validar-promocao"})
    @DBAutoCommit
    public boolean validarFornecedorPromocao(@RequestParam(value="idPromocao") Long idPromocao, @RequestParam(required=false, value="id") Long idPromocaoFornecedor, @RequestParam(value="value") Long idFornecedor) {
        boolean isValidar = idPromocaoFornecedor == null || !((PromocaoFornecedor)PromocaoFornecedorRN.getInstance().buscarPorId(idPromocaoFornecedor)).getIdFornecedor().equals(idFornecedor);
        return !isValidar || idPromocao == null || idFornecedor == null || PromocaoFornecedorRN.getInstance().buscaPorPromocaoFornecedor(idPromocao, idFornecedor) == null;
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public PromocaoReturnWrapper gravarDados(@RequestBody PromocaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Promocao promocao = wrapper.getPromocao();
        PromocaoFornecedor promocaoFornecedor = wrapper.getPromocaoFornecedor();
        Long idPai = PromocaoRN.getInstance().incluir(promocao, SessaoUtil.getSessao());
        promocaoFornecedor.setIdPromocao(idPai);
        Long idFilho = PromocaoFornecedorRN.getInstance().incluir((AbstractPojo)promocaoFornecedor, SessaoUtil.getSessao());
        return new PromocaoReturnWrapper(idPai, idFilho);
    }

    protected GridBuilder<PromocaoFornecedorRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idPromocao", "idPromocao", 0, false), new ColunaSQL("idFornecedor", "idFornencedor", 0, false), new ColunaSQL("nome", "nomeFornecedor", "fornecedor", 100, true, new String[]{"fk_promoforn_fornecedor"}), new ColunaSQL("valor", "Valor", 40, true), new ColunaSQL("percentual", "Percentual", 50, true));
        return new GridBuilder(PromocaoFornecedorRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(PromocaoFornecedor promocaoFornecedor, Optional<Long> parentId) {
        promocaoFornecedor.setCodigo(PromocaoRN.getInstance().buscarPorId(promocaoFornecedor.getIdPromocao()).getCodigo());
        promocaoFornecedor.setFornecedor(((Entidade)EntidadeRN.getInstance().buscarPorId(promocaoFornecedor.getIdFornecedor())).getCodigo());
    }

    protected void beforeUpdate(PromocaoFornecedor promocaoFornecedor, Optional<Long> parentId) {
        promocaoFornecedor.setFornecedor(((Entidade)EntidadeRN.getInstance().buscarPorId(promocaoFornecedor.getIdFornecedor())).getCodigo());
    }

    protected String getCacheId() {
        return "promocoes-fornecedor";
    }
}

