/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPreco;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPrecoItem;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco.ReajustePrecoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco.ReajustePrecoRN;
import br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco.ReajustePrecoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco.ReajusteWrapper;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reajuste-preco"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Reajuste de pre\u00e7os", ICONE="icon-faturar", ROTA="/estoques/reajuste-preco", PROGRAMA=302)
public class ReajustePrecoCrudController
extends SimpleCrudController<ProgramacaoAlteracaoPreco, ProgramacaoAlteracaoPrecoRN> {
    @Autowired
    private TaskManager taskManager;

    @RequestMapping(value={"/buscar-produtos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ProgramacaoAlteracaoPrecoItem> visualisarProdutos(@RequestBody ReajustePrecoWrapper reajuste) throws UnicoMensagemUsuarioException {
        if (reajuste.isPrecoFixo() && reajuste.getValorReajuste().compareTo(BigDecimal.ZERO) <= 0) {
            throw new UnicoMensagemUsuarioException("WPRC36", "Por favor informe um pre\u00e7o fixo v\u00e1lido.");
        }
        List itens = ProgramacaoAlteracaoPrecoItemRN.getInstance().getItensReajustePreco(SessaoUtil.getSessao(), reajuste.getProduto(), reajuste.getIdFornecedor(), reajuste.getIdHierarquia(), reajuste.getIdHierarquiaUnichef(), reajuste.getIdFamilia(), reajuste.getValorReajuste(), reajuste.getIdBaseado(), reajuste.isPrecoFixo(), reajuste.isMostrarInativos(), reajuste.getPrecoDe(), reajuste.getPrecoAte());
        itens.removeIf(item -> Util.bigDecimalNullOrZero((BigDecimal)item.getNovoPrecoProduto()));
        return itens;
    }

    @RequestMapping(value={"/opcao-arredondamento"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ProgramacaoAlteracaoPrecoItem> opcoesArredontamento(@RequestBody List<ProgramacaoAlteracaoPrecoItem> itens, @RequestParam int opcao) throws UnicoMensagemUsuarioException {
        switch (opcao) {
            case 1: {
                ProgramacaoAlteracaoPrecoItemRN.getInstance().arrendondarCasaDecimalParaNove(itens, false);
                break;
            }
            case 2: {
                ProgramacaoAlteracaoPrecoItemRN.getInstance().arrendondarCasaDecimalParaNove(itens, true);
                break;
            }
            case 3: {
                ProgramacaoAlteracaoPrecoItemRN.getInstance().arrendondarCasaDecimalParaZero(itens, false);
                break;
            }
            case 4: {
                ProgramacaoAlteracaoPrecoItemRN.getInstance().arrendondarCasaDecimalParaZero(itens, true);
                break;
            }
            default: {
                throw new UnicoMensagemUsuarioException("WWW613", "Op\u00e7\u00e3o de arredondamento, n\u00e3o suportada");
            }
        }
        return itens;
    }

    @RequestMapping(value={"/reajustar"}, method={RequestMethod.POST})
    @DBTransaction
    public String reajustarPreco(@RequestBody ReajusteWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (!wrapper.getItens().isEmpty()) {
            if (this.taskManager.verificaSeExistePorTipoTenant(TipoJob.REAJUSTAR_PRECOS, ContextoHolder.getTenant(), true)) {
                throw new UnicoMensagemUsuarioException("BATCH10", "Existe uma tarefa de reajuste de pre\u00e7os em andamento. Aguarde o processamento antes de realizar um novo reajuste.");
            }
            if (wrapper.getItens().size() <= 50) {
                Sessao sessao = SessaoUtil.getSessao();
                return ReajustePrecoRN.getInstance().reajustarPrecos(sessao, wrapper.getReajuste().getIdAplicar(), wrapper.getItens(), wrapper.getReajuste().getDataProgramada());
            }
            1 iCreateTask = new /* Unavailable Anonymous Inner Class!! */;
            iCreateTask.createTask((Object)wrapper, "Reajuste de pre\u00e7os");
            return "O reajuste de pre\u00e7os solicitado foi agendado com sucesso. Voc\u00ea ser\u00e1 notificado quando o processo for conclu\u00eddo.";
        }
        throw new UnicoMensagemUsuarioException("WPRC35", "N\u00e3o existem produtos para serem reajustados. Por favor verifique.");
    }

    static /* synthetic */ TaskManager access$000(ReajustePrecoCrudController x0) {
        return x0.taskManager;
    }
}

