/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.recalculocomissao;

import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.util.CacheLocal;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.comissao.regranegocio.ComissaoVendedorRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.recalculocomissao.RecalculoComissaoWrapper;

public class JobRecalculoComissao
extends AbstractPrepareJob {
    public JobRecalculoComissao(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, "Comiss\u00f5es recalculadas com sucesso!");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, "Erro ao recalcular comiss\u00f5es!");
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        RecalculoComissaoWrapper recalculo = (RecalculoComissaoWrapper)this.getObjetoDeserializado(RecalculoComissaoWrapper.class);
        Entidade vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(recalculo.getIdVendedor());
        if (vendedor != null) {
            ComissaoVendedorRN.getInstance().recalcularComissoes(Contexto.getInstance().getSessao(), vendedor, recalculo.getPeriodoInicial(), recalculo.getPeriodoFinal(), recalculo.isAtualizarPercentualComissao(), false, null, new CacheLocal());
        } else {
            ComissaoVendedorRN.getInstance().recalcularComissoes(Contexto.getInstance().getSessao(), recalculo.getPeriodoInicial(), recalculo.getPeriodoFinal(), recalculo.isAtualizarPercentualComissao());
        }
    }
}

