/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.relatorio.relatorioconfigurado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.TipoValorFiltroRelatorioConfigurado;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoColunaWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoFiltroWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoParametroWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoReferenciaWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoWeb;
import br.intelidata.commons.modulo.ferramentas.regranegocio.RelatorioConfiguradoWebRN;
import br.intelidata.commons.modulo.geradorrelatorio.regranegocio.RelatorioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.SqlHelperService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.relatorio.RelatorioCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.relatorio.RelatorioParametrosWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.relatorio.ValidacaoRelatorioWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/relatorios-configurados"})
public class RelatorioConfiguradoCrudController
extends RelatorioCrudController {
    private SqlHelperService sqlHelper;

    @Autowired
    public RelatorioConfiguradoCrudController(SqlHelperService sqlHelperService) {
        super(true, false);
        this.sqlHelper = sqlHelperService;
    }

    @RequestMapping(value={"/buscar-filtros"})
    @DBAutoCommit
    public RelatorioConfiguradoWeb buscarParametrosFiltros(@RequestParam Long idRelatorio) throws UnicoMensagemUsuarioException {
        RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)RelatorioConfiguradoWebRN.getInstance().buscarPorId(idRelatorio);
        if (relatorio != null) {
            return relatorio;
        }
        throw new UnicoMensagemUsuarioException("WWW285", "Relat\u00f3rio n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/validar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ValidacaoRelatorioWrapper validarRelatorio(@RequestBody RelatorioConfiguradoWeb relatorio) throws UnicoMensagemUsuarioException {
        RelatorioParametrosWrapper parametros = (RelatorioParametrosWrapper)JsonUtil.fromJson((String)relatorio.getRelatorioSerializado(), RelatorioParametrosWrapper.class);
        if (parametros == null) {
            throw new UnicoMensagemUsuarioException("WWW288", "Os par\u00e2metros n\u00e3o foram configurados.");
        }
        return this.validarSql(relatorio, parametros);
    }

    @RequestMapping(value={"/carregar-valores"}, method={RequestMethod.POST})
    @DBAutoCommit
    public RelatorioConfiguradoParametroWeb carregarValor(@RequestBody RelatorioConfiguradoParametroWeb relatorio) {
        String valores = RelatorioRN.getInstance().getValorComboPorSelect(relatorio.getValorPadrao());
        relatorio.setValorPadrao(valores);
        return relatorio;
    }

    protected String getCacheId() {
        return "relatorios-configurados";
    }

    protected GridBuilder<RelatorioConfiguradoWebRN> getGridBuilder() {
        List colunas = this.getColunas();
        colunas.add(new ColunaSQL("descricaoTabelaBase", "Tabela base", 0, true));
        GridBuilder grid = new GridBuilder(((RelatorioConfiguradoWebRN)this.rn).getTabela(), colunas, "relatorio_conf");
        grid.addReferenciaDefault(new Referencia("tabelaBase"));
        return grid;
    }

    protected void beforeSave(RelatorioConfiguradoWeb relatorioConfiguradoWeb, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)relatorioConfiguradoWeb, parentId);
        if (StringUtil.stringNullOrEmpty((String)relatorioConfiguradoWeb.getTabelaBase())) {
            throw new UnicoMensagemUsuarioException("WWW282", "Tabela base n\u00e3o informada. Verifique!");
        }
        if (StringUtil.stringNullOrEmpty((String)relatorioConfiguradoWeb.getRelatorioSerializado())) {
            throw new UnicoMensagemUsuarioException("WWW283", "N\u00e3o foram configuradas colunas para o relat\u00f3rio. Verifique!");
        }
        RelatorioParametrosWrapper parametrosWrapper = (RelatorioParametrosWrapper)JsonUtil.fromJson((String)relatorioConfiguradoWeb.getRelatorioSerializado(), RelatorioParametrosWrapper.class);
        if (parametrosWrapper == null) {
            throw new UnicoMensagemUsuarioException("WWW289", "Os par\u00e2metros n\u00e3o foram configurados.");
        }
        List colunas = parametrosWrapper.getColunas().stream().map(RelatorioConfiguradoColunaWeb::getAlias).collect(Collectors.toList());
        colunas.addAll(parametrosWrapper.getReferencias().stream().map(RelatorioConfiguradoReferenciaWeb::getAlias).collect(Collectors.toList()));
        List parametros = parametrosWrapper.getParametros().stream().map(RelatorioConfiguradoParametroWeb::getParametro).collect(Collectors.toList());
        for (RelatorioConfiguradoFiltroWeb filtro : parametrosWrapper.getFiltros()) {
            if (!StringUtil.stringNullOrEmpty((String)filtro.getCampo())) {
                if (!colunas.contains(filtro.getCampo())) {
                    throw new UnicoMensagemUsuarioException("WWW290", "O campo " + filtro.getDescricaoCampo() + " deve estar configurado em 'Colunas' ou 'Refer\u00eancias'.");
                }
                if (filtro.getTipoValor() != TipoValorFiltroRelatorioConfigurado.PARAMETRO) continue;
                if (!parametros.contains(filtro.getValor1().toString())) {
                    throw new UnicoMensagemUsuarioException("WWW291", "O par\u00e2metro " + filtro.getValor1() + " deve estar configurado em 'Par\u00e2metros'.");
                }
                if (!Operador.ENTRE.equals((Object)filtro.getOperacao()) || parametros.contains(filtro.getValor2().toString())) continue;
                throw new UnicoMensagemUsuarioException("WWW292", "O par\u00e2metro " + filtro.getValor2() + " deve estar configurado em 'Par\u00e2metros'.");
            }
            if (filtro.getOperadoLogico() != null || filtro.getSeparador() != null) continue;
            throw new UnicoMensagemUsuarioException("WWW293", "Filtro inv\u00e1lido, por favor verifique!");
        }
        ValidacaoRelatorioWrapper validacao = this.validarSql(relatorioConfiguradoWeb, parametrosWrapper);
        if (!StringUtil.stringNullOrEmpty((String)validacao.getErroGerado())) {
            throw new UnicoMensagemUsuarioException("WWW294", "Ocorreu um erro ao validar o relat\u00f3rio. ".concat(validacao.getErroGerado()));
        }
    }

    private ValidacaoRelatorioWrapper validarSql(RelatorioConfiguradoWeb relatorio, RelatorioParametrosWrapper parametros) throws UnicoMensagemUsuarioException {
        List colunasSQL = RelatorioConfiguradoWebRN.getInstance().getColunaSQL(parametros.getColunas(), new ArrayList());
        HashMap valoresFiltros = new HashMap();
        USelect select = RelatorioConfiguradoWebRN.getInstance().getSqlRelatorio(relatorio.getTabelaBase(), colunasSQL, parametros.getColunas(), parametros.getFiltros(), parametros.getParametros(), parametros.getReferencias(), parametros.getOrdens(), valoresFiltros);
        Sql sql = new Sql(select);
        String erro = this.sqlHelper.validarQuery(sql);
        Map<String, List<RelatorioConfiguradoFiltroWeb>> mapFiltros = parametros.getFiltros().stream().filter(f -> f.getOperacao() != null && f.getTipoValor() == TipoValorFiltroRelatorioConfigurado.PARAMETRO).collect(Collectors.groupingBy(RelatorioConfiguradoFiltroWeb::getCampo));
        List condicoes = select.getCondicoes().stream().map(condicao -> {
            RelatorioConfiguradoFiltroWeb filtro;
            if (condicao.getOperador() != null && (filtro = (RelatorioConfiguradoFiltroWeb)mapFiltros.getOrDefault(condicao.getAliasCondicao(), Collections.emptyList()).stream().filter(f -> f.getOperacao() == condicao.getOperador()).findFirst().orElse(null)) != null) {
                if (filtro.getOperacao() == Operador.ENTRE) {
                    return new Condicao(false, condicao.getAliasCondicao(), condicao.getOperador(), filtro.getValor1().toString(), filtro.getValor2().toString());
                }
                if (filtro.getOperacao() == Operador.CONTIDO_EM || filtro.getOperacao() == Operador.NAO_CONTIDO_EM) {
                    return new Condicao(condicao.getAliasCondicao(), condicao.getOperador(), new String[]{filtro.getValor1().toString()});
                }
                return new Condicao(condicao.getAliasCondicao(), condicao.getOperador(), filtro.getValor1().toString());
            }
            return condicao;
        }).collect(Collectors.toList());
        select.getCondicoes().clear();
        select.addAll(condicoes);
        String query = SGBDManager.getInstance().geraSql(select);
        return new ValidacaoRelatorioWrapper(query, erro);
    }
}

