/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.seguranca.politicaseguranca;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.pojo.enuns.TypeIpAccess;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.IpAccessRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliarSeguranca", NOME="Pol\u00edtica de seguran\u00e7a", ROTA="/ferramentas/politicas-seguranca", ICONE="icon-shield", PROGRAMA=1504)
public class PoliticaSegurancaSimpleController
extends SimpleController {
    private final CacheService cacheService;
    private final HttpServletRequest httpServletRequest;

    @Autowired
    public PoliticaSegurancaSimpleController(CacheService cacheService, HttpServletRequest httpServletRequest) {
        this.cacheService = cacheService;
        this.httpServletRequest = httpServletRequest;
    }

    @RequestMapping(value={"/api/politicas-seguranca"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarPolitica(@RequestBody Controle controleDummy) throws UnicoMensagemUsuarioException {
        Controle controle = ControleRN.getInstance().getRegistroControle();
        controle.setPoliticaSeguranca(controleDummy.getPoliticaSeguranca());
        controle.setTipoAcessoIp(controleDummy.getTipoAcessoIp());
        ControleRN.getInstance().alterar((AbstractPojo)controle, SessaoUtil.getSessao());
        if (controle.getTipoAcessoIp() == TypeIpAccess.WHITE) {
            String ip = BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest);
            if (!IpAccessRN.getInstance().ipExists(ip, TypeIpAccess.WHITE)) {
                IpAccessRN.getInstance().save(SessaoUtil.getSessao(), ip, TypeIpAccess.WHITE);
            }
        }
        this.cacheService.clear();
    }

    @RequestMapping(value={"/api/politicas-seguranca/configuracoes-atuais"})
    @DBAutoCommit
    public Controle buscarDadosPolitica() {
        return ControleRN.getInstance().buscar();
    }

    @RequestMapping(value={"/politicas-seguranca/politica"})
    @DBAutoCommit
    public NivelPoliticaSeguranca buscarPoliticaSeguranca() {
        return ControleRN.getInstance().getNivelPoliticaSeguranca();
    }
}

