/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.systax.produtos;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.systax.SystaxProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.SystaxProdutoCommonRN;
import br.intelidata.commons.modulo.integracao.integracaosystax.regranegocio.SystaxProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.systax.produtos.ProdutoSystaxCrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/produtos-systax"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Produtos Systax", ROTA="/ferramentas/produtos-systax", ICONE="icon-produto", PROGRAMA=1375)
public class ProdutoSystaxCrudController
extends CrudController<SystaxProduto, SystaxProdutoRN> {
    private final TaskManager taskManager;

    @Autowired
    public ProdutoSystaxCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)SystaxProdutoRN.getInstance(), SystaxProduto::new);
        this.taskManager = taskManager;
    }

    protected GridBuilder<SystaxProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idProduto"));
        colunas.add(new ColunaSQL("id", "idgrupo", "Grupo", 0, false, new String[]{"fk_systaxproduto_produto", "fk_produto_hierarquia"}));
        colunas.add(new ColunaSQL("codigo", "codigoproduto", "C\u00f3digo", 120, true, new String[]{"fk_systaxproduto_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeproduto", "Produto", 300, true, new String[]{"fk_systaxproduto_produto"}));
        colunas.add(new ColunaSQL("status", "Status", 100, true));
        colunas.add(new ColunaSQL("ean", "EAN", 120, true));
        colunas.add(new ColunaSQL("ncm", "NCM", 80, true));
        colunas.add(new ColunaSQL("exTipi", "EX TIPI", 100, true));
        colunas.add(new ColunaSQL("cest", "CEST", 80, true));
        colunas.add(new ColunaSQL("cstIcms", "ICMS", 80, true));
        colunas.add(new ColunaSQL("aliquotaIcms", "%ICMS", 80, true));
        colunas.add(new ColunaSQL("percentualReducaoBaseIcms", "%Red", 80, true));
        colunas.add(new ColunaSQL("cstPisCofinsSaida", "PIS/COFINS S", 120, true));
        colunas.add(new ColunaSQL("aliquotaPisSaida", "%PIS", 80, true));
        colunas.add(new ColunaSQL("aliquotaCofinsSaida", "%COFINS", 100, true));
        colunas.add(new ColunaSQL("cstPisCofinsEntrada", "PIS/COFINS E", 120, true));
        colunas.add(new ColunaSQL("aliquotaPisEntrada", "%PIS", 80, true));
        colunas.add(new ColunaSQL("aliquotaCofinsEntrada", "%COFINS", 100, true));
        colunas.add(new ColunaSQL("codigoReceitaSemContribuicao", "Nat. Receita", 120, true));
        ColunaSQL colunaStatusCodigo = new ColunaSQL("status", "statuscodigo", "C\u00f3digo status", 0, false, new String[0]);
        colunaStatusCodigo.setNaoAlterarValorEnum(true);
        colunas.add(colunaStatusCodigo);
        GridBuilder gridBuilder = new GridBuilder(SystaxProdutoRN.getInstance().getTabela(), colunas);
        gridBuilder.setOrdemDefault(new Ordem("codigoproduto"));
        return gridBuilder;
    }

    @RequestMapping(value={"/atualizar-produtos"})
    @DBAutoCommit
    public void atualizarProdutos(@RequestParam List<Long> idsProdutos) throws UnicoMensagemUsuarioException {
        this.executarJob(TipoJob.SYSTAX_ATUALIZAR_PRODUTOS, idsProdutos);
    }

    @RequestMapping(value={"/atualizar-tributacao"})
    @DBAutoCommit
    public void atualizarTributacao() throws UnicoMensagemUsuarioException {
        this.executarJob(TipoJob.SYSTAX_ATUALIZAR_TRIBUTACAO, null);
    }

    @RequestMapping(value={"/consultar-tributacao"})
    @DBAutoCommit
    public void consultarTributacao() throws UnicoMensagemUsuarioException {
        this.executarJob(TipoJob.SYSTAX_CONSULTAR_TRIBUTACAO, null);
    }

    @RequestMapping(value={"/incluir-produtos"})
    @DBTransaction
    public void incluirProdutos() throws UnicoMensagemUsuarioException {
        SystaxProdutoCommonRN.getInstance().incluirNovosProdutos(SessaoUtil.getSessao());
        SystaxProdutoCommonRN.getInstance().transformarEmPendentesProdutosAlterados();
    }

    private void executarJob(TipoJob tipoJob, List<Long> idsProdutos) throws UnicoMensagemUsuarioException {
        1 createTask = new /* Unavailable Anonymous Inner Class!! */;
        createTask.createTask(null);
    }

    protected String getCacheId() {
        return "produtos-systax";
    }

    static /* synthetic */ TaskManager access$000(ProdutoSystaxCrudController x0) {
        return x0.taskManager;
    }
}

