/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tasks;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoExtensaoPlanilha;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.FiltroAvancadoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReportParams;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/task"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Gerenciador de tarefas", ROTA="/jobs-executor/task", PROGRAMA=1466, ICONE="icon-processar")
public class TaskSimpleCotroller {
    private final TaskManager taskManager;
    private final TaskService taskService;
    private final StorageService fileServer;
    private final ResponseEntityService responseEntityService;

    public TaskSimpleCotroller(TaskManager taskManager, TaskService taskService, StorageService fileServer, ResponseEntityService responseEntityService) {
        this.taskManager = taskManager;
        this.taskService = taskService;
        this.fileServer = fileServer;
        this.responseEntityService = responseEntityService;
    }

    @PostMapping(value={"/tasks"})
    public List<Task> getTasks(@RequestBody FiltroAvancadoWrapper filtro) {
        FilterField filterTenant = new FilterField();
        filterTenant.setField("tenant");
        filterTenant.setFilter(Operator.OPERADOR_IGUAL.getDescricao());
        filterTenant.setType("String");
        filterTenant.setValue1(ContextoHolder.getTenant());
        FilterField filterUsuario = new FilterField();
        filterUsuario.setField("metadata");
        filterUsuario.setFilter(Operator.OPERADOR_CONTENHA.getDescricao());
        filterUsuario.setType("String");
        String usuario = "idUsuario=" + SessaoUtil.getSessao().getIdUsuario();
        filterUsuario.setValue1(usuario);
        filtro.getFilterField().add(filterTenant);
        filtro.getFilterField().add(filterUsuario);
        return this.taskService.getTasks(filtro).stream().filter(task -> !this.taskManager.isCached(task.getClassName())).collect(Collectors.toList());
    }

    @GetMapping(value={"/download"})
    public String downloadXML(@RequestParam(value="idTask") Long idTask) {
        Task task = this.taskService.findById(idTask);
        return this.fileServer.publishArquivo(task.getUrl());
    }

    @GetMapping(value={"/em-execucao"})
    public boolean isJobExecucao(@RequestParam TipoJob tipoJob) {
        return this.taskService.existeProcessoPendente(new TipoJob[]{tipoJob});
    }

    @PostMapping(value={"/open/{id}"})
    public ResponseEntity<byte[]> getOpenReport(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        Task task = this.taskService.findById(id);
        AbstractReportParams abstractReport = (AbstractReportParams)JsonUtil.fromJson((String)task.getParameters(), AbstractReportParams.class);
        if (abstractReport != null) {
            File file = this.fileServer.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.JobExecutor, task.getUrl(), true, true);
            return RelatorioUtil.visualizar((byte[])FileUtil.file2ByteArray((File)file), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)abstractReport.getSaidaRelatorio(), (String)task.getName(), (TipoExtensaoPlanilha)abstractReport.getExtensao());
        }
        throw new UnicoMensagemUsuarioException("BATCH1", "N\u00e3o foi poss\u00edvel carregar o relat\u00f3rio");
    }
}

