/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.TipoComissaoFaixaDescontoCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoFaixaLucroCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoFamiliaCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoHierarquiaCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoPautaCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoComissaoProdutoCommonRN;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoPautaRN;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Tipos de comiss\u00e3o", ROTA="/financeiros/tipos-comissao", PROGRAMA=56)
public class TipoComissaoCrudController
extends CrudController<TipoComissao, TipoComissaoRN> {
    public TipoComissaoCrudController() {
        super((AbstractRegraNegocio)TipoComissaoRN.getInstance(), TipoComissao::new);
    }

    protected GridBuilder<TipoComissaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 0, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 0, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 0, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 0, true));
        return new GridBuilder(TipoComissaoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "tipos-comissao";
    }

    protected void beforeRead(TipoComissao tipoComissao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List pautas = TipoComissaoPautaRN.getInstance().buscarPautasPorTipoComissao(SessaoUtil.getSessao(), tipoComissao.getId(), true);
        tipoComissao.setPautas(pautas);
    }

    protected void afterSave(TipoComissao tipoComissao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        TipoComissaoPautaCommonRN.getInstance().excluirPautasPorTipoComissao(SessaoUtil.getSessao(), tipoComissao.getId());
        TipoComissaoPautaCommonRN.getInstance().gravarPautas(SessaoUtil.getSessao(), tipoComissao.getId(), tipoComissao.getPautas());
    }

    protected void beforeDelete(TipoComissao tipoComissao) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        TipoComissaoProdutoCommonRN.getInstance().excluirProdutosPorTipoComissao(sessao, tipoComissao.getId());
        TipoComissaoHierarquiaCommonRN.getInstance().excluirHierarquiasPorTipoComissao(sessao, tipoComissao.getId());
        TipoComissaoFamiliaCommonRN.getInstance().excluirFamiliasPorTipoComissao(sessao, tipoComissao.getId());
        TipoComissaoPautaCommonRN.getInstance().excluirPautasPorTipoComissao(sessao, tipoComissao.getId());
        TipoComissaoFaixaDescontoCommonRN.getInstance().excluirFaixasDescontoPorTipoComissao(sessao, tipoComissao.getId());
        TipoComissaoFaixaLucroCommonRN.getInstance().excluirFaixasLucroPorTipoComissao(sessao, tipoComissao.getId());
    }
}

