/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.produto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoProdutoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-produto"})
public class TipoComissaoProdutoCrudController
extends CrudController<TipoComissaoProduto, TipoComissaoProdutoRN> {
    public TipoComissaoProdutoCrudController() {
        super((AbstractRegraNegocio)TipoComissaoProdutoRN.getInstance(), TipoComissaoProduto::new);
        this.dependsOn("idTipoComissao");
    }

    protected GridBuilder<TipoComissaoProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissao", "idTipoComissao", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoProduto", "Cod. Produto", 30, true, new String[]{"fk_tipcomprod_prod"}));
        colunas.add(new ColunaSQL("nome", "nomeProduto", "Produto", 30, true, new String[]{"fk_tipcomprod_prod"}));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 50, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 50, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 50, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 50, true));
        return new GridBuilder(TipoComissaoProdutoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(TipoComissaoProduto tipoComissaoProduto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoProduto.getIdTipoComissao())) {
            throw new UnicoMensagemUsuarioException("WWW85", "Comiss\u00e3o n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)tipoComissaoProduto.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WCMS27", "Produto n\u00e3o informado! Verifique.");
        }
        if (this.produtoExiste(tipoComissaoProduto.getIdTipoComissao(), tipoComissaoProduto.getId(), tipoComissaoProduto.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WCMS28", "Produto j\u00e1 existe! Verifique.");
        }
    }

    protected String getCacheId() {
        return "tipos-comissao-produto";
    }

    private boolean produtoExiste(Long idTipoComissao, Long id, Long idProduto) {
        return TipoComissaoProdutoRN.getInstance().buscarComissaoPorTipoComissaoProduto(idTipoComissao, idProduto) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoProduto)TipoComissaoProdutoRN.getInstance().buscarPorId(id)).getIdProduto().equals(idProduto));
    }
}

