/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unichef.combinacao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Combinacao;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CombinacaoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/combinacoes"})
@SubMenuMapping(MENU="SubMenuGourmetGeral", NOME="Combina\u00e7\u00f5es", ROTA="/unichefs/combinacoes", ICONE="icon icon-trabalharcom", PROGRAMA=1354)
public class CombinacaoCrudController
extends CrudController<Combinacao, CombinacaoRN> {
    public CombinacaoCrudController() {
        super((AbstractRegraNegocio)CombinacaoRN.getInstance(), Combinacao::new, true, true, TipoArquivoArmazenado.Combinacao);
    }

    protected GridBuilder<CombinacaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        return new GridBuilder(CombinacaoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeRead(Combinacao combinacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)combinacao.getCaminhoImagem())) {
            combinacao.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Combinacao, TipoImagem.Icone, combinacao.getCaminhoImagem()));
        }
    }

    protected void beforeUpdate(Combinacao combinacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Combinacao combinacaoOriginal = (Combinacao)CombinacaoRN.getInstance().buscarPorId(combinacao.getId());
        String caminhoImagemOriginal = combinacaoOriginal.getCaminhoImagem();
        if (!StringUtil.stringNullOrEmpty((String)caminhoImagemOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Combinacao, TipoImagem.Pequena, caminhoImagemOriginal);
            if (StringUtil.stringNullOrEmpty((String)combinacao.getCaminhoImagem()) || !combinacao.getCaminhoImagem().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Combinacao, caminhoImagemOriginal);
            } else {
                combinacao.setCaminhoImagem(caminhoImagemOriginal);
            }
        }
    }

    protected void beforeSave(Combinacao combinacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty((List)combinacao.getSubgrupos())) {
            throw new UnicoMensagemUsuarioException("WUCF64", "Por favor, informe pelo menos um subgrupo.");
        }
    }

    protected void beforeDelete(Combinacao combinacao) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)combinacao.getCaminhoImagem())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.GruposProdutoUnichef, combinacao.getCaminhoImagem());
        }
    }

    protected String getCacheId() {
        return "combinacoes";
    }
}

