/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importarxmlnfce;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ImportacaoXmlNfce;
import br.intelidata.commons.domain.regranegocio.ImportacaoXmlNfceCommonRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.unipaf.importarxmlnfce.ImportacaoXmlNfceCriticaWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unipaf.nfce.importacao.ImportacaoNfceRelatorio;
import unipaf.nfce.importacao.ImportadorXmlNfce;
import unipaf.nfce.importacao.ImportadorXmlNfceCommon;
import unipaf.nfce.importacao.ValidadorItensXmlNfce;

@RestController
@RequestMapping(value={"/api/importacoes-xml-nfce"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Importa\u00e7\u00e3o de NFC-e por XML", ROTA="/pdvs/importacoes-xml-nfce", PROGRAMA=1456)
public class ImportacaoXmlNfceController {
    private final ResponseEntityService responseEntityService;

    public ImportacaoXmlNfceController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/processar-arquivos"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBTransaction
    public ResponseEntity<byte[]> processarArquivo(@RequestPart(value="file") MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        byte[] arquivo = this.getArquivo(multipartFile);
        Sessao sessao = SessaoUtil.getSessao();
        LinkedHashMap<String, byte[]> mapArquivos = new LinkedHashMap<String, byte[]>();
        try (ByteArrayInputStream fis = new ByteArrayInputStream(arquivo);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = zis.getNextEntry()) != null) {
                int len;
                String name = zipEntry.getName();
                if (!name.endsWith(".xml")) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((len = zis.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                int idx = 0;
                if (name.contains("\\")) {
                    idx = name.lastIndexOf("\\") + 1;
                } else if (name.contains("/")) {
                    idx = name.lastIndexOf("/") + 1;
                }
                mapArquivos.put(name.substring(idx), byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("COM280000", "N\u00e3o foi poss\u00edvel abrir o arquivo " + multipartFile.getName() + ". Verifique.");
        }
        if (mapArquivos.isEmpty()) {
            throw new UnicoMensagemUsuarioException("COM280001", "Nenhum arquivo XML encontrado no arquivo " + multipartFile.getName() + ". Verifique.");
        }
        ValidadorItensXmlNfce validadorItensXml = new ValidadorItensXmlNfce();
        ImportacaoNfceRelatorio relatorio = new ImportacaoNfceRelatorio();
        this.validar(sessao, mapArquivos, validadorItensXml, relatorio);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=mensagens_importacao_nfse.pdf");
        if (!validadorItensXml.getCriticas().isEmpty() || !validadorItensXml.getCriticasCfop().isEmpty()) {
            UUID uuid = UUID.randomUUID();
            List listaImportacaoXmlNfces = mapArquivos.entrySet().stream().map(entry -> new ImportacaoXmlNfce(uuid.toString(), (String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.toList());
            ImportacaoXmlNfceCommonRN.getInstance().excluirPorIdUsuario(sessao, sessao.getIdUsuario());
            ImportacaoXmlNfceCommonRN.getInstance().gravarLista(0, listaImportacaoXmlNfces, sessao);
            ImportacaoXmlNfceCriticaWrapper wrapper = new ImportacaoXmlNfceCriticaWrapper(uuid.toString(), validadorItensXml.getCriticas(), validadorItensXml.getCriticasCfop());
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("X-Uniplusweb-lista-criticas", "true");
            headers.add("Access-Control-Expose-Headers", "X-Uniplusweb-lista-criticas");
            String json = JsonUtil.toJson((Object)wrapper);
            return new ResponseEntity((Object)json.getBytes(StandardCharsets.UTF_8), (MultiValueMap)headers, HttpStatus.OK);
        }
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.AUTORIZADO, mapArquivos, validadorItensXml, relatorio);
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.CANCELADO, mapArquivos, validadorItensXml, relatorio);
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.INUTILIZADO, mapArquivos, validadorItensXml, relatorio);
        headers.add("X-Uniplusweb-rel-criticas", "" + relatorio.temErroParaExibir());
        headers.add("Access-Control-Expose-Headers", "X-Uniplusweb-rel-criticas");
        if (relatorio.temErroParaExibir()) {
            byte[] contents = relatorio.imprimir().getMalote().extrai("pdf");
            headers.setContentType(MediaType.APPLICATION_PDF);
            return new ResponseEntity((Object)contents, (MultiValueMap)headers, HttpStatus.OK);
        }
        return null;
    }

    private void validar(Sessao sessao, Map<String, byte[]> arquivosXml, ValidadorItensXmlNfce validadorItensXml, ImportacaoNfceRelatorio relatorio) {
        for (Map.Entry<String, byte[]> entryXML : arquivosXml.entrySet()) {
            String stringXml = Util.byteArrayToString((byte[])entryXML.getValue());
            String nomeArquivoXml = entryXML.getKey();
            ImportadorXmlNfceCommon.TipoXML tipoXML = ImportadorXmlNfceCommon.determinaTipoDeXmlRapidamente((String)stringXml);
            if (!tipoXML.equals((Object)ImportadorXmlNfceCommon.TipoXML.AUTORIZADO)) continue;
            try {
                validadorItensXml.validar(stringXml, sessao);
            }
            catch (UnicoMensagemUsuarioException ex) {
                relatorio.registrarErro("Valida\u00e7\u00e3o com falha: " + nomeArquivoXml + " (" + ex.getMessage() + ")");
            }
        }
    }

    private void importar(Sessao sessao, ImportadorXmlNfceCommon.TipoXML tipoXmlFiltro, Map<String, byte[]> arquivosXml, ValidadorItensXmlNfce validadorItensXml, ImportacaoNfceRelatorio relatorio) {
        for (Map.Entry<String, byte[]> entryXML : arquivosXml.entrySet()) {
            String stringXml = Util.byteArrayToString((byte[])entryXML.getValue());
            String nomeArquivoXml = entryXML.getKey();
            ImportadorXmlNfceCommon.TipoXML tipoXmlAtual = ImportadorXmlNfceCommon.determinaTipoDeXmlRapidamente((String)stringXml);
            if (tipoXmlAtual == tipoXmlFiltro) {
                try {
                    ImportadorXmlNfce.importar((ImportadorXmlNfceCommon.TipoXML)tipoXmlAtual, (String)stringXml, (ValidadorItensXmlNfce)validadorItensXml, (Sessao)sessao);
                }
                catch (UnicoMensagemUsuarioException ex) {
                    relatorio.registrarErro("Importa\u00e7\u00e3o com falha: " + nomeArquivoXml + " (" + ex.getMessage() + ")");
                }
                continue;
            }
            if (tipoXmlAtual != ImportadorXmlNfceCommon.TipoXML.DESCONHECIDO) continue;
            relatorio.registrarErro("XML desconhecido: " + nomeArquivoXml);
        }
    }

    private byte[] getArquivo(MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        byte[] arquivo;
        try {
            arquivo = multipartFile.getBytes();
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("COM280002", "N\u00e3o foi posss\u00edvel importar o arquivo. Por favor verifique a integridade do arquivo.");
        }
        return arquivo;
    }

    @RequestMapping(value={"/importar"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> importar(@RequestBody ImportacaoXmlNfceCriticaWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ValidadorItensXmlNfce validador = new ValidadorItensXmlNfce();
        ImportacaoNfceRelatorio relatorio = new ImportacaoNfceRelatorio();
        List listaImportacaoXmlNfces = ImportacaoXmlNfceCommonRN.getInstance().buscarPorUuid(wrapper.getUuid());
        LinkedHashMap<String, byte[]> mapArquivos = new LinkedHashMap<String, byte[]>();
        for (ImportacaoXmlNfce importacaoXmlNfce : listaImportacaoXmlNfces) {
            mapArquivos.put(importacaoXmlNfce.getNomeArquivo(), importacaoXmlNfce.getArquivoXml());
        }
        this.validar(sessao, mapArquivos, validador, relatorio);
        validador.setCriticas(wrapper.getCriticas());
        validador.setCriticasCfop(wrapper.getCriticasCfop());
        ImportadorXmlNfce.resolverCriticas((Sessao)sessao, (ValidadorItensXmlNfce)validador);
        ImportadorXmlNfce.gravarAcoesDasCriticas((Sessao)sessao, (ValidadorItensXmlNfce)validador);
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.AUTORIZADO, mapArquivos, validador, relatorio);
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.CANCELADO, mapArquivos, validador, relatorio);
        this.importar(sessao, ImportadorXmlNfceCommon.TipoXML.INUTILIZADO, mapArquivos, validador, relatorio);
        if (relatorio.temErroParaExibir()) {
            Object result = relatorio.imprimir().getMalote().get("pdf");
            byte[] pdf = result instanceof File ? Util.file2ByteArray((File)((File)result)) : (byte[])result;
            return this.responseEntityService.createPDFResponse(pdf, "Erros importa\u00e7\u00e3o");
        }
        ImportacaoXmlNfceCommonRN.getInstance().excluirPorUuid(sessao, wrapper.getUuid());
        return null;
    }
}

