/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.b2c.Banner;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.b2c.GrupoShop;
import br.intelidata.commons.domain.pojo.b2c.ProdutoResumido;
import br.intelidata.commons.domain.pojo.b2c.Slide;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.b2c.OrigemAgrupamento;
import br.intelidata.commons.domain.regranegocio.b2c.ConfiguracaoShopRN;
import br.intelidata.commons.domain.regranegocio.b2c.GrupoShopRN;
import br.intelidata.commons.domain.regranegocio.b2c.ProdutoResumidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractConfiguracaoUniplusShop
extends SimpleCrudController<ConfiguracaoShop, ConfiguracaoShopRN> {
    @RequestMapping(method={RequestMethod.GET})
    @DBAutoCommit
    public ConfiguracaoShop get(Long parentId) {
        ConfiguracaoShop configuracao = ConfiguracaoShopRN.getInstance().buscarConfiguracao();
        if (configuracao != null) {
            this.readImage(configuracao);
        }
        return configuracao;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ConfiguracaoShop configuracaoShop) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)configuracaoShop.getIdFilialEstoque())) {
            configuracaoShop.setIdFilialEstoque(SessaoUtil.getSessao().getIdFilial());
        }
        this.beforeSave((AbstractPojo)configuracaoShop);
        Long id = ConfiguracaoShopRN.getInstance().gravar(0, configuracaoShop, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)configuracaoShop);
        return id;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody ConfiguracaoShop configuracaoShop) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)configuracaoShop.getIdFilialEstoque())) {
            configuracaoShop.setIdFilialEstoque(SessaoUtil.getSessao().getIdFilial());
        }
        this.beforeSave((AbstractPojo)configuracaoShop);
        this.updateImages(configuracaoShop, ConfiguracaoShopRN.getInstance().buscarConfiguracao());
        Long id = ConfiguracaoShopRN.getInstance().gravar(1, configuracaoShop, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)configuracaoShop);
        return id;
    }

    public void loadFile(MultipartFile[] files, ConfiguracaoShop configuracaoShop) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            Map<Object, Object> mapSlides = new HashMap();
            Map<Object, Object> mapBanners = new HashMap();
            if (!ListMapUtil.listNullOrEmpty((List)configuracaoShop.getSlides())) {
                mapSlides = configuracaoShop.getSlides().stream().collect(Collectors.groupingBy(Slide::getImage));
            }
            if (!ListMapUtil.listNullOrEmpty((List)configuracaoShop.getBanners())) {
                mapBanners = configuracaoShop.getBanners().stream().collect(Collectors.groupingBy(Banner::getImage));
            }
            for (MultipartFile file : files) {
                String caminho;
                List banners;
                String caminho2;
                List slides;
                Object[] split;
                String nome = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)nome) || ListMapUtil.arrayNullOrEmpty((Object[])(split = nome.split("\\|")))) continue;
                Object fieldName = split[0];
                Object imageName = split[1];
                if (((String)fieldName).equalsIgnoreCase("imagesSlide") && !ListMapUtil.listNullOrEmpty((List)(slides = (List)mapSlides.get(imageName)))) {
                    caminho2 = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Slide_Shop, file);
                    if (!ListMapUtil.listNullOrEmpty((List)slides)) {
                        slides.forEach(s -> s.setImage(caminho2));
                    }
                }
                if (((String)fieldName).equalsIgnoreCase("imagesBanner") && !ListMapUtil.listNullOrEmpty((List)(banners = (List)mapBanners.get(imageName)))) {
                    caminho2 = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Banner_Shop, file);
                    if (!ListMapUtil.listNullOrEmpty((List)banners)) {
                        banners.forEach(s -> s.setImage(caminho2));
                    }
                }
                if (((String)fieldName).equalsIgnoreCase("image")) {
                    caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, file);
                    configuracaoShop.setLogo(caminho);
                }
                if (!((String)fieldName).equalsIgnoreCase("imageIcon")) continue;
                caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, file);
                configuracaoShop.setIcon(caminho);
            }
        }
    }

    private void readImage(ConfiguracaoShop configuracaoShop) {
        if (!StringUtil.stringNullOrEmpty((String)configuracaoShop.getLogo())) {
            configuracaoShop.setLogo(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, TipoImagem.Pequena, configuracaoShop.getLogo()));
        }
        if (!StringUtil.stringNullOrEmpty((String)configuracaoShop.getIcon())) {
            configuracaoShop.setIcon(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, TipoImagem.Pequena, configuracaoShop.getIcon()));
        }
        configuracaoShop.getSlides().forEach(slide -> {
            if (!NumberUtil.longNullOuZero((Long)slide.getCategory())) {
                HierarquiaGrupoProduto grupo;
                if (configuracaoShop.getAgrupamento().equals((Object)OrigemAgrupamento.GRUPO_PRODUTO)) {
                    grupo = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarNome(slide.getCategory());
                    if (grupo != null) {
                        slide.setDescription(grupo.getNome());
                    }
                } else {
                    grupo = (GrupoShop)GrupoShopRN.getInstance().buscarNome(slide.getCategory());
                    if (grupo != null) {
                        slide.setDescription(grupo.getNome());
                    }
                }
            }
            String url = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Slide_Shop, TipoImagem.Thumbnail, slide.getImage());
            slide.setImage(url.replace("\\", "/"));
        });
        configuracaoShop.getBanners().forEach(banner -> {
            if (!NumberUtil.longNullOuZero((Long)banner.getCategory())) {
                if (configuracaoShop.getAgrupamento().equals((Object)OrigemAgrupamento.GRUPO_PRODUTO)) {
                    HierarquiaGrupoProduto grupo = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarNome(banner.getCategory());
                    if (grupo != null) {
                        banner.setDescription(grupo.getNome());
                    }
                } else {
                    GrupoShop grupo = (GrupoShop)GrupoShopRN.getInstance().buscarNome(banner.getCategory());
                    if (grupo != null) {
                        banner.setDescription(grupo.getNome());
                    }
                }
            } else if (!NumberUtil.longNullOuZero((Long)banner.getProduct())) {
                ProdutoResumido produto = ProdutoResumidoRN.getInstance().buscarPorIdProduto(banner.getProduct());
                if (produto != null) {
                    banner.setDescription(produto.getNome());
                }
            } else if (!NumberUtil.longNullOuZero((Long)banner.getBrand())) {
                banner.setDescription(EntidadeRN.getInstance().buscarNomeEntidadePorIdWeb(banner.getBrand()));
            }
            banner.setImage(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Banner_Shop, TipoImagem.Thumbnail, banner.getImage()));
        });
    }

    private void updateImages(ConfiguracaoShop novaConfiguracao, ConfiguracaoShop configuracaoAtual) {
        String caminhoOriginal;
        if (!StringUtil.stringNullOrEmpty((String)configuracaoAtual.getLogo())) {
            caminhoOriginal = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, TipoImagem.Pequena, configuracaoAtual.getLogo());
            if (novaConfiguracao.getLogo().equals(caminhoOriginal)) {
                novaConfiguracao.setLogo(configuracaoAtual.getLogo());
            }
        }
        if (!StringUtil.stringNullOrEmpty((String)configuracaoAtual.getIcon())) {
            caminhoOriginal = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.UniplusShop, TipoImagem.Pequena, configuracaoAtual.getIcon());
            if (novaConfiguracao.getIcon().equals(caminhoOriginal)) {
                novaConfiguracao.setIcon(configuracaoAtual.getIcon());
            }
        }
        if (!ListMapUtil.listNullOrEmpty((List)novaConfiguracao.getSlides())) {
            Map mapAtual = configuracaoAtual.getSlides().stream().collect(Collectors.toMap(Slide::getId, Function.identity()));
            novaConfiguracao.getSlides().forEach(slide -> {
                Slide slideAtual = (Slide)mapAtual.get(slide.getId());
                if (slideAtual != null) {
                    String caminhoOriginal = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Slide_Shop, TipoImagem.Thumbnail, slideAtual.getImage());
                    if (slide.getImage().equals(caminhoOriginal)) {
                        slide.setImage(slideAtual.getImage());
                    }
                }
            });
        }
        if (!ListMapUtil.listNullOrEmpty((List)novaConfiguracao.getBanners())) {
            Map mapBannerAtual = configuracaoAtual.getBanners().stream().collect(Collectors.toMap(Banner::getId, Function.identity()));
            novaConfiguracao.getBanners().forEach(banner -> {
                Banner bannerAtual = (Banner)mapBannerAtual.get(banner.getId());
                if (bannerAtual != null) {
                    String caminhoOriginal = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Banner_Shop, TipoImagem.Thumbnail, bannerAtual.getImage());
                    if (banner.getImage().equals(caminhoOriginal)) {
                        banner.setImage(bannerAtual.getImage());
                    }
                }
            });
        }
    }
}

