/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.pagina;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.b2c.Pagina;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.b2c.PaginaRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paginas"})
@SubMenuMapping(MENU="SubMenuUniplusShopGeral", ICONE="icon-ascii", NOME="P\u00e1ginas", ROTA="/uniplusshop/paginas", PROGRAMA=9010)
public class PaginaCrudController
extends CrudController<Pagina, PaginaRN> {
    public PaginaCrudController() {
        super((AbstractRegraNegocio)PaginaRN.getInstance(), Pagina::new);
    }

    protected String getCacheId() {
        return "paginas";
    }

    protected GridBuilder<PaginaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("titulo", "T\u00edtulo", 0, true));
        colunas.add(new ColunaSQL("indexarPagina", "Permitir mecanismo de busca", 0, true));
        colunas.add(new ColunaSQL("link", "Link permanente", 0, true));
        return new GridBuilder(PaginaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(Pagina pagina, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Pagina paginaExistente = PaginaRN.getInstance().buscarPorLink(pagina.getLink());
        if (paginaExistente != null) {
            throw new UnicoMensagemUsuarioException("WWW626", "O link permanente da p\u00e1gina j\u00e1 foi configurado. Verifique!");
        }
    }
}

