/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.artigowiki;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.logtracker.LogManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ArtigoWiki;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoConsultaArtigoWiki;
import br.intelidata.commons.domain.pojo.enuns.TipoSistemaArtigoWiki;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.ferramentas.regranegocio.ArtigoWikiRN;
import br.intelidata.core.aop.InterfaceAfterCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/artigos-wiki"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Artigos Wiki", ROTA="/intelidata/artigos-wiki", PROGRAMA=5006)
public class ArtigoWikiCrudController
extends CrudController<ArtigoWiki, ArtigoWikiRN>
implements InterfaceAfterCommit {
    public ArtigoWikiCrudController() {
        super((AbstractRegraNegocio)ArtigoWikiRN.getInstance(), ArtigoWiki::new);
    }

    protected String getCacheId() {
        return "artigos-wiki";
    }

    protected GridBuilder<ArtigoWikiRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("tipoSistema", "Tipo de sistema", 200, true, TipoSistemaArtigoWiki.class));
        colunas.add(new ColunaSQL("tipoConsulta", "Tipo de consulta", 200, true, TipoConsultaArtigoWiki.class));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 200, true));
        colunas.add(new ColunaSQL("chaveConsulta", "Chave da consulta", 50, true));
        colunas.add(new ColunaSQL("idArtigoWiki", "ID do artigo", 200, true));
        GridBuilder grid = new GridBuilder(ArtigoWikiRN.getInstance().getTabela(), colunas);
        return grid;
    }

    protected void beforeRead(ArtigoWiki artigo, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (artigo.getTipoSistema() != null) {
            artigo.setTipoSistemaDTO(artigo.getTipoSistema().name());
        }
        if (artigo.getTipoConsulta() != null) {
            artigo.setTipoConsultaDTO(artigo.getTipoConsulta().name());
        }
    }

    protected void beforeSave(ArtigoWiki artigo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!Util.stringNullOrEmpty((String)artigo.getTipoSistemaDTO())) {
            artigo.setTipoSistema((TipoSistemaArtigoWiki)EnumUtils.getPorNomeConstante(TipoSistemaArtigoWiki.class, (String)artigo.getTipoSistemaDTO()));
        }
        if (!Util.stringNullOrEmpty((String)artigo.getTipoConsultaDTO())) {
            artigo.setTipoConsulta((TipoConsultaArtigoWiki)EnumUtils.getPorNomeConstante(TipoConsultaArtigoWiki.class, (String)artigo.getTipoConsultaDTO()));
        }
    }

    public void afterCommit() {
        LogManager.getInstance().limparCacheArtigosWiki();
    }
}

