/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.fechamentoecf;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.report.Report;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.fechamentoecf.FechamentoECF;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.fechamentoecf.FechamentoECFReportExecuter;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/fechamentos-ecf"})
@SubMenuMapping(MENU="SubMenuFinanceiroRelatorio", NOME="Fechamento do PDV", ICONE="icon-imprimir", ROTA="/reports-financeiro/fechamentos-ecf", PROGRAMA=417)
public class FechamentoECFReportController
extends Report<FechamentoECF> {
    @DBAutoCommit
    public FechamentoECF get() throws UnicoMensagemUsuarioException {
        FechamentoECF fechamentoECF;
        ConfiguracaoCampos configuracaoCampos = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), this.nomeTabelaRelatorio());
        if (configuracaoCampos != null) {
            fechamentoECF = (FechamentoECF)JSONUtil.getObject((JSONObject)configuracaoCampos.getCamposSerializados(), FechamentoECF.class);
        } else {
            fechamentoECF = new FechamentoECF();
            fechamentoECF.setPeriodoInicial(DataHoraFactory.getLocalDateInicioMes());
            fechamentoECF.setPeriodoFinal(DataHoraFactory.getLocalDateFimMes());
            fechamentoECF.setDetalharAdms(true);
            fechamentoECF.setDetalharCarteirasDigitais(true);
            fechamentoECF.setDetalharSangrias(true);
        }
        return fechamentoECF;
    }

    protected String nomeTabelaRelatorio() {
        return "fechamentos-ecf";
    }

    public boolean isPersistir() {
        return true;
    }

    public Class<? extends AbstractJob> job() {
        return FechamentoECFReportExecuter.class;
    }
}

