/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.rankingvenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.contabil.MesFiscal;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioMensalRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.commons.modulo.vendas.relatorio.RankingVendasLucratividadeRelatorio;
import br.intelidata.commons.sped.fiscal.TipoCalculoCusto;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.rankingvenda.RankingVenda;
import java.time.LocalDate;

public class RankingVendaReportExecuter
extends AbstractReporteExecute<RankingVenda> {
    public RankingVendaReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        RankingVenda rankingVenda = (RankingVenda)this.fromJson(parametrosObj, RankingVenda.class);
        return this.executa(sessao, rankingVenda);
    }

    public Remessa executa(Sessao sessao, RankingVenda parametros) throws UnicoMensagemUsuarioException {
        Entidade cliente = null;
        Entidade fornecedor = null;
        Produto produto = null;
        Entidade vendedor = null;
        Promocao promocao = null;
        String familia = null;
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdFornecedor())) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdFornecedor());
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdCliente())) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdCliente());
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(parametros.getIdProduto());
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdVendedor())) {
            vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdVendedor());
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdFamilia())) {
            familia = ((FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(parametros.getIdFamilia())).getNome();
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdPromocao())) {
            promocao = PromocaoRN.getInstance().buscarPorId(parametros.getIdPromocao());
        }
        if (parametros.getTipoCusto() == TipoCalculoCusto.CUSTO_MEDIO_ATUAL || parametros.getTipoCusto() == TipoCalculoCusto.CUSTO_MEDIO_DATA) {
            LocalDate dataBaseFinal;
            if (parametros.getPeriodoInicial() == null) {
                throw new UnicoMensagemUsuarioException("WVND59", "Por favor informe o per\u00edodo inicial.");
            }
            LocalDate dataBaseInicial = parametros.getPeriodoInicial().withDayOfMonth(1);
            LocalDate localDate = dataBaseFinal = parametros.getPeriodoFinal() == null ? DataHoraFactory.getData().withDayOfMonth(1) : parametros.getPeriodoFinal().withDayOfMonth(1);
            while (dataBaseInicial.compareTo(dataBaseFinal) < 1) {
                String ano = String.valueOf(dataBaseInicial.getYear());
                MesFiscal mes = (MesFiscal)EnumUtils.getPorId(MesFiscal.class, (Object)dataBaseInicial.getMonthValue());
                for (Filial filial : parametros.getFiliais()) {
                    if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL)) {
                        if (!CustoMedioMensalRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getIdEmpresa(), ano, mes)) continue;
                        throw new UnicoMensagemUsuarioException("WVND60", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                    }
                    if (!CustoMedioDiarioRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getId(), ano, mes)) continue;
                    throw new UnicoMensagemUsuarioException("WVND61", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                }
                dataBaseInicial = dataBaseInicial.plusMonths(1L);
            }
        }
        return new RankingVendasLucratividadeRelatorio().getRelatorio(SessaoUtil.getSessao(), parametros.getPeriodoInicial(), parametros.getPeriodoFinal(), fornecedor, cliente, parametros.getIdGrupoProdutoFiltro(), produto, parametros.getFiliais(), parametros.getSaida(), vendedor, parametros.getIdFamilia(), familia, parametros.getTipoRelatorio(), parametros.getTipoCusto(), parametros.isAbaterDevolucoes(), parametros.getTipoVenda(), promocao, parametros.getOrdem(), parametros.getIppt(), parametros.isConsideraSegundoComissionado(), parametros.getIdLocalEstoque(), null, null, null, null, parametros.isApuraLucroPorMarkup(), parametros.getIdFabricante(), parametros.getIdMarca(), parametros.getIdPautaPreco(), parametros.getNivelTotalizador());
    }
}

