/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.core.sql.ConversorResultSet2;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.service.SelectJson;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class SelectJson {
    protected USelect uSelect;
    protected ArrayList<ColunaSQL> colunasParaIncluir = new ArrayList();
    protected ArrayList<ColunaSQL> colunasParaPesquisar = new ArrayList();

    public SelectJson(String tabela, String colunaParaPesquisar, String ... colunasParaIncluir) {
        this.uSelect = new USelect(tabela);
        this.colunasParaIncluir.add(new ColunaSQL("id"));
        this.uSelect.add(new ColunaSQL("id"));
        this.colunasParaPesquisar.add(new ColunaSQL(colunaParaPesquisar));
        this.colunasParaIncluir.add(new ColunaSQL(colunaParaPesquisar));
        this.uSelect.add(new ColunaSQL(colunaParaPesquisar));
        if (colunasParaIncluir != null) {
            for (String colunaParaIncluir : colunasParaIncluir) {
                this.colunasParaIncluir.add(new ColunaSQL(colunaParaIncluir));
                this.uSelect.add(new ColunaSQL(colunaParaIncluir));
            }
        }
        this.uSelect.add(new Ordem(colunaParaPesquisar));
    }

    public SelectJson(String tabela, ArrayList<String> colunasParaPesquisar, String ... colunasParaIncluir) {
        this.uSelect = new USelect(tabela);
        this.colunasParaIncluir.add(new ColunaSQL("id"));
        this.uSelect.add(new ColunaSQL("id"));
        colunasParaPesquisar.stream().forEach(c -> {
            this.colunasParaPesquisar.add(new ColunaSQL(c));
            this.colunasParaIncluir.add(new ColunaSQL(c));
            this.uSelect.add(new ColunaSQL(c));
        });
        if (colunasParaIncluir != null) {
            for (String colunaParaIncluir : colunasParaIncluir) {
                this.colunasParaIncluir.add(new ColunaSQL(colunaParaIncluir));
                this.uSelect.add(new ColunaSQL(colunaParaIncluir));
            }
        }
        this.uSelect.add(new Ordem(colunasParaPesquisar.get(0)));
    }

    public ResponseEntity<String> getDataJson() {
        return this.getDataJson(null, null);
    }

    public ResponseEntity<String> getDataJson(String filter) {
        return this.getDataJson(null, filter);
    }

    public ResponseEntity<String> getDataJson(String query, String filter) {
        this.uSelect.getCondicoes().clear();
        this.filter(filter);
        if (query != null) {
            IntStream.range(0, this.colunasParaPesquisar.size()).forEach(index -> {
                String coluna = ((ColunaSQL)this.colunasParaPesquisar.get(index)).getNome();
                this.uSelect.add(new Condicao(coluna, Operador.CONTEM, query));
                if (index + 1 < this.colunasParaPesquisar.size()) {
                    this.uSelect.add(new Condicao(OperadorLogico.OU));
                }
            });
            this.uSelect.setLimit(10);
        }
        Sql sql = new Sql(this.uSelect);
        List dados = ConversorResultSet2.converterSqlWeb((List)this.colunasParaIncluir, null, (Sql)sql, (int)0);
        sql.close();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Type", "application/json; charset=UTF-8");
        return new ResponseEntity((Object)JsonUtil.toJson((List)dados, (List)this.colunasParaIncluir), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private void filter(String filter) {
        List filters;
        if (filter != null && (filters = (List)JsonUtil.fromJson((String)filter, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)) != null) {
            block6: for (FilterField filterField : filters) {
                this.uSelect.add((ColunaSQL)new Referencia(filterField.getField()));
                switch (filterField.getType()) {
                    case "Integer": {
                        this.filterInteger(filterField);
                        continue block6;
                    }
                }
                throw new RuntimeException("Tipo de dado n\u00e3o implementado: " + filterField.getType());
            }
        }
    }

    private void filterInteger(FilterField filterField) {
        Operator operator = (Operator)EnumUtils.getPorId(Operator.class, (Object)filterField.getFilter());
        switch (2.$SwitchMap$br$intelidata$uniplusweb$core$grid$Operator[operator.ordinal()]) {
            case 1: {
                this.uSelect.add(new Condicao(filterField.getField(), Operador.IGUAL, NumberUtil.toLong((String)filterField.getValue1())));
                break;
            }
            default: {
                throw new RuntimeException("Operador n\u00e3o implementado: " + filterField.getFilter());
            }
        }
    }
}

